package ca.tecreations;

import a.test.LoadCursor;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * 
 * @author Tim 
 */
public class Cursor {
    public static int CROSSHAIR_CURSOR = java.awt.Cursor.CROSSHAIR_CURSOR;
    public static int CUSTOM_CURSOR = java.awt.Cursor.CUSTOM_CURSOR;
    public static int DEFAULT_CURSOR = java.awt.Cursor.DEFAULT_CURSOR;
    public static int E_RESIZE_CURSOR = java.awt.Cursor.E_RESIZE_CURSOR;
    public static int HAND_CURSOR = java.awt.Cursor.HAND_CURSOR;
    public static int MOVE_CURSOR = java.awt.Cursor.MOVE_CURSOR;
    public static int N_RESIZE_CURSOR = java.awt.Cursor.N_RESIZE_CURSOR;
    public static int NE_RESIZE_CURSOR = java.awt.Cursor.NE_RESIZE_CURSOR;
    public static int NW_RESIZE_CURSOR = java.awt.Cursor.NW_RESIZE_CURSOR;
    public static int S_RESIZE_CURSOR = java.awt.Cursor.S_RESIZE_CURSOR;
    public static int SE_RESIZE_CURSOR = java.awt.Cursor.SE_RESIZE_CURSOR;
    public static int SW_RESIZE_CURSOR = java.awt.Cursor.SW_RESIZE_CURSOR;
    public static int TEXT_CURSOR = java.awt.Cursor.TEXT_CURSOR;
    public static int W_RESIZE_CURSOR = java.awt.Cursor.W_RESIZE_CURSOR;
    public static int WAIT_CURSOR = java.awt.Cursor.WAIT_CURSOR;

    public static LoadCursor lc = LoadCursor.instance;
    public static Cursor instance = new Cursor();
    public static HashMap<String, CursorData> cursors;
    public static final boolean retest = false;
    static {
        if (retest) {
            File.prune(ProjectPath.getTecCursorsPath(), true);
        }
        if (!new File(ProjectPath.getTecCursorsPath()).exists()) {
            instance.createTecCursors();
        } else {
            instance.loadCursors();
        }
    }
    public static boolean debug = true;
    public static boolean verbose = false;
    public static CursorData active = instance.get("default");

    public static List<String> names = LoadCursor.names;
    
    public Cursor() {
    }

    private void createTecCursors() {
        List<String> names = lc.names;
        
        cursors = new HashMap<String, CursorData>();
        
        BufferedImage squished;
        for (int i = 0; i < names.size(); i++) {
            String name = names.get(i);
            squished = lc.getForTec(name);
            //Magnifier.magnify(squished);
            CursorData cursorData = new CursorData(name,
                                                   squished.getWidth(),
                                                   squished.getHeight(),
                                                   lc.getSquashedPixels(),
                                                   lc.getMaskPoints(),
                                                   new Point(0,0),
                    name.equals("no") ? TColor.red : CursorData.DEFAULT_OUTLINE_COLOR
            );
            cursors.put(name, cursorData);
//            Magnifier.magnify(cursors.get(name).getImage());
        }
        saveCursors();
    }

    public CursorData get(String name) {
        return cursors.get(name);
    }

    public CursorData getActive() {
        return active;
    }

    public List<String> getCursorNames() {
        return LoadCursor.names;
    }
    
    public static HashMap<String, CursorData> getCursors() {
        return cursors;
    }

    public static CursorData getDefaultCursor() {
        return cursors.get("default");
    }

    public java.awt.Cursor getJavaCursor(Image image, Point hotSpot, String name) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit.createCustomCursor(image, hotSpot, name);
    }

    public static java.awt.Cursor getJavaCursor(String name) {
        name = name.toUpperCase();
        if (name.contains("CROSSHAIR")) {
            return java.awt.Cursor.getPredefinedCursor(CROSSHAIR_CURSOR);
        } else if (name.contains("CUSTOM")) {
            return java.awt.Cursor.getPredefinedCursor(CUSTOM_CURSOR);
        } else if (name.contains("DEFAULT")) {
            return java.awt.Cursor.getPredefinedCursor(DEFAULT_CURSOR);
        } else if (name.contains("E_RESIZE")) {
            return java.awt.Cursor.getPredefinedCursor(E_RESIZE_CURSOR);
        } else if (name.contains("HAND")) {
            return java.awt.Cursor.getPredefinedCursor(HAND_CURSOR);
        } else if (name.contains("MOVE")) {
            return java.awt.Cursor.getPredefinedCursor(MOVE_CURSOR);
        } else if (name.contains("N_RESIZE")) {
            return java.awt.Cursor.getPredefinedCursor(N_RESIZE_CURSOR);
        } else if (name.contains("NE_RESIZE")) {
            return java.awt.Cursor.getPredefinedCursor(NE_RESIZE_CURSOR);
        } else if (name.contains("NW_RESIZE")) {
            return java.awt.Cursor.getPredefinedCursor(NW_RESIZE_CURSOR);
        } else if (name.contains("S_RESIZE")) {
            return java.awt.Cursor.getPredefinedCursor(S_RESIZE_CURSOR);
        } else if (name.contains("SE_RESIZE")) {
            return java.awt.Cursor.getPredefinedCursor(SE_RESIZE_CURSOR);
        } else if (name.contains("SW_RESIZE")) {
            return java.awt.Cursor.getPredefinedCursor(SW_RESIZE_CURSOR);
        } else if (name.contains("TEXT")) {
            return java.awt.Cursor.getPredefinedCursor(TEXT_CURSOR);
        } else if (name.contains("W_RESIZE")) {
            return java.awt.Cursor.getPredefinedCursor(W_RESIZE_CURSOR);
        } else if (name.contains("WAIT")) {
            return java.awt.Cursor.getPredefinedCursor(WAIT_CURSOR);
        } else {
            return null;
        }
    }

    public static CursorData getRandom() {
        int elements = names.size();
        int rand = Platform.getRandom(elements);
        return cursors.get(names.get(rand));
    }
    
    public static void loadCursors() {
        File[] fa = new File(ProjectPath.getTecCursorsPath()).tecListFiles();

        cursors = new HashMap<String, CursorData>();

        System.out.println("Cursor.loadCursors: fa.length: " + fa.length);

        for (int i = 0; i < fa.length; i++) {
            if (fa[i].isFile() && fa[i].getExtension().equals("cursor")) {
                Properties props = new Properties(fa[i]);
                String name = fa[i].getFileNameOnly();
                if (debug && verbose) System.out.println("Cursor.loadCursors: Loading: name: " + name);
                int width = props.getInt("width");
                int height = props.getInt("height");
                List<Pixel> pixels = Pixel.getList(props.get("pixels"));
                List<Point> maskPoints = Statics.getListOfPoint(props.get("mask.points"));
                Point hotSpot = props.getPoint("hotspot");
                TColor outlineColor = props.getTColor("outline.color");
                // if not exists?
                cursors.put(name,
                            new CursorData(name,width,height,pixels,maskPoints,hotSpot,outlineColor)
                );
            } else {
                System.err.println("Cursor.loadCursors: Non .cursor file entry found: " + fa[i].getAbsolutePath());
            }
        }
    }

    public static void main(String[] args) {
//        List<String> names = LoadCursor.getNames();
//        for(int i = 0;i < names.size();i++) {
//            Cursor cursor = instance.get(names.get(i));
//            cursor.setOutlineColor(Color.red);
//            Magnifier.magnify(cursor.getImage());
//        }
    }

    public static void saveCursors() {
        String path = ProjectPath.getTecCursorsPath();
        Set<String> names = cursors.keySet();
        Iterator it = names.iterator();
        String name;
        CursorData cursorData;
        while (it.hasNext()) {
            name = (String) it.next();
            cursorData = cursors.get(name);
            Properties cursorProps = new Properties(path + name + ".cursor");
            cursorProps.set("width",cursorData.getWidth());
            cursorProps.set("height",cursorData.getHeight());
            cursorProps.set("pixels", "[" + cursorData.getPixelsCSV() + "]");
            cursorProps.set("hotspot", cursorData.getHotSpot());
            cursorProps.set("mask.points", "[" + cursorData.getMaskPoints() + "]");
            cursorProps.set("outline.color",cursorData.getOutlineColor());
        }
    }

    public static void setActive(String name) {
        System.out.println("Setting active to: " + name);
        active = instance.get(name);
    }
    
    public static void setCursorData(String name, CursorData cursorData) {
        cursors.put(name, cursorData);
    }

}
