package ca.tecreations.lang.java;

import ca.tecreations.File;
import ca.tecreations.ProjectPath;
import ca.tecreations.TecData;
/**
 *
 * @author tim
 */
public class GetTecClassPath {
    String result = ProjectPath.getDocumentsPath() + TecData.TEC_VERSION + File.separator;;
    
    public GetTecClassPath() {
        // always prefer the distribution .jar file
        if (new File(ProjectPath.getDownloadsPath() + TecData.TEC_VERSION + ".jar").exists()) {
            result = ProjectPath.getDownloadsPath() + TecData.TEC_VERSION + ".jar";
        // then we can delete it and use the snapshot
        } else if (new File(ProjectPath.getProjectsHome() + TecData.TEC_VERSION).exists()) {
            result = ProjectPath.getProjectsHome() + TecData.TEC_VERSION + File.separator;
        }
        // or temporarily rename that, for backwards compatibility, use the Documents/TEC_VERSION/ path

        // I've been renaming to next version, this product is meant to go small to large, so I do, 1, 2, 3
        // etc. we could institute version naming, but that's not really applicable for this project yet
        // I basically work towards a target, then stop, for each app within our reach
        
        // the current target is to have all the code available for runtime and editing to get to 'Toy'
        // basically I need code-editing, dev-ops access and control, database daily backup, daily code backup
        // option of code snapshotting for tutorials, and all within code we control and thus have sysop access
        // to
    }
    
    public String getResult() { return result; }
}
