package ca.tecreations.components;
import java.awt.*;
import java.awt.event.*;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
/**
 * 
 * @author Tim
 */
public class GetPassword extends JDialog implements ActionListener, ItemListener, WindowListener {
    JFrame app;
    JPasswordField passField = new JPasswordField(16);
    JCheckBox showPass = new JCheckBox("Show Password");
    JButton ok = new JButton("OK");
    
    public GetPassword(JFrame app,String title) {
        super(app,title,true);
        this.app = app;
        addWindowListener(this);
        showPass.addItemListener(this);
        ok.addActionListener(this);
        setSize(400,90);
        setLayout(new BorderLayout());
        JPanel panel1 = new JPanel(false);
        panel1.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel1.add(new JLabel("Password: "),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel1.add(passField,gbc);
        passField.addKeyListener(new KeyAdapter() {
            @Override
            public void keyPressed(KeyEvent e) {
                if(e.getKeyCode() == KeyEvent.VK_ENTER){
                    close();
                }
            }
        });
        
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel1.add(showPass,gbc);
        
        add(panel1,BorderLayout.NORTH);
        add(ok,BorderLayout.SOUTH);
        setLocationRelativeTo(app);
    }
    
    public void actionPerformed(ActionEvent e) {
        close();
    }
    
    public void close() {
        //System.out.println("Size: " + getSize());
        setVisible(false);
    }
    
    public char[] getPassword() { return passField.getPassword(); }
    
    public void itemStateChanged(ItemEvent e) {
        if (showPass.isSelected()) {
            passField.setEchoChar((char)0);
        } else {
            passField.setEchoChar('*');
        }
    }
    
    public void windowOpened(WindowEvent e) {}
    
    public void windowClosing(WindowEvent e) {
        close();
    }
    
    public void windowClosed(WindowEvent e) {
        close();
    }

    public void windowIconified(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowActivated(WindowEvent e) {}
    public void windowDeactivated(WindowEvent e) {}    
}
