package ca.tecreations.apps;

import ca.tecreations.File;
import ca.tecreations.ProjectPath;
import ca.tecreations.SystemTool;
import ca.tecreations.TecData;
import ca.tecreations.lang.java.GetClassPathFor;
import ca.tecreations.net.bc.SecurityTool;

import java.security.KeyStore;

/**
 *
 * @author Tim
 */
public class MakeLocalStorePairs {
    SecurityTool tool = new SecurityTool();
        
    public MakeLocalStorePairs() {
        String path = ProjectPath.getTecreationsPath() + "security" + File.separator;
        // if you are getting an UnrecoverableKeyException, ensure that your keypass and storepass are equal
        KeyStore serverCS = tool.createKeyStore2(tool.JKS,"local-server","storepass".toCharArray(),path + "server-credentials","storepass".toCharArray());
        KeyStore clientCS = tool.createKeyStore2(tool.JKS,"local-client","storepass".toCharArray(),path + "client-credentials","storepass".toCharArray());
        KeyStore serverTS = tool.createTrustStoreFrom(tool.JKS,clientCS,path + "server-trust","storepass".toCharArray());
        KeyStore clientTS = tool.createTrustStoreFrom(tool.JKS,serverCS,path + "client-trust","storepass".toCharArray());
    }
    
    public static void launch(boolean relaunch) {
        if (relaunch) relaunch();
        new MakeLocalStorePairs(); // make the stores with dependencies in classpath
    }
    
    public static void main(String[] args) {
        boolean relaunch = false;
        if (args.length == 0) relaunch = true;
        else relaunch = Boolean.parseBoolean(args[0]);
        launch(relaunch);
    }
    
    public static void relaunch() {
        String tecJarPath = ProjectPath.getTecJarPath();
        String cmd = "java -cp " + new GetClassPathFor(tecJarPath).getResult();
        cmd += " " + MakeLocalStorePairs.class.getName() + " false";
        new SystemTool().spawn(cmd,true);
    }
}
