package contrib.io.mailtrap;

import ca.tecreations.*;

import java.util.ArrayList;
import java.util.List;

import jakarta.activation.*;
import jakarta.mail.*;
import jakarta.mail.internet.*;

/**
 *
 * @author Tim
 */
public class SendHtml {

    public SendHtml(Session session, String from, String to, String subject, String body) 
    throws Exception 
    {
        new SendHtml(session,from,to,subject,body,null);
    }
    
    public SendHtml(Session session, String from, String to, String subject, String body,List<String> attach) 
    throws Exception
    {
        List<String> froms = new ArrayList<>();
        froms.add(from);
        List<String> tos = new ArrayList<>();
        tos.add(to);
        new SendHtml(session,froms,froms,tos,null,null,subject,body,attach);
    }

    public SendHtml(Session session, List<String> from,
            List<String> replyTo,
            List<String> to,
            List<String> ccs,
            List<String> bccs,
            String subject,
            String body,
            List<String> attach) 
    throws Exception {
        MimeMessage message = new MimeMessage(session);

        message.setFrom(new InternetAddress("tim@tecreations.ca"));
        String replyList = "";
        int replySize = replyTo.size();
        for (int i = 0; i < replySize; i++) {
            replyList += replyTo.get(i);
            if (i < replySize - 1) {
                replyList += ",";
            }
        }
        message.setReplyTo(InternetAddress.parse(replyList, false));
        String toList = "";
        int toSize = to.size();
        for (int i = 0; i < toSize; i++) {
            toList += to.get(i);
            if (i < toSize - 1) {
                toList += ",";
            }
        }
        message.setRecipients(Message.RecipientType.TO,InternetAddress.parse(toList, false));
  
        // To get the array of ccaddresses
        if (ccs != null) {
            for( int i = 0; i < ccs.size(); i++ ) {
                message.addRecipient(Message.RecipientType.CC, new InternetAddress(ccs.get(i)));
            }
        }
 
        // To get the array of bccaddresses
        if (bccs != null) {
            for( int i = 0; i < bccs.size(); i++ ) {
                message.addRecipient(Message.RecipientType.BCC, new InternetAddress(bccs.get(i)));
            }
        }

        message.setSubject(subject);
        MimeMultipart multipart = new MimeMultipart();

        // Create a new MimeBodyPart for the email content.
        BodyPart messageBodyPart = new MimeBodyPart();

        // Set the HTML content to the MimeBodyPart.
        messageBodyPart.setContent(body, "text/html");

        // Add the email content part to the multipart.
        multipart.addBodyPart(messageBodyPart);

        // Add the attachments
        if (attach != null) {
            for(int i = 0;i < attach.size();i++) {
                // Create a MimeBodyPart for the file attachment.
                messageBodyPart = new MimeBodyPart();

                // Set the file source for attachment.
                DataSource source = new FileDataSource(StringTool.getUnwrapped(attach.get(i)));

                // Attach the file to the email using DataHandler.
                messageBodyPart.setDataHandler(new DataHandler(source));

                // Name the attached file.
                messageBodyPart.setFileName(new File(attach.get(i)).getName());

                // Add the attachment to the multipart content.
                multipart.addBodyPart(messageBodyPart);        
            }
        } 

        // Create a new MimeBodyPart for the embedded image.
        //        messageBodyPart = new MimeBodyPart();

        // Use a DataSource to load the image from the given path.
//        DataSource fds = new FileDataSource("path-to-image");
        // Set the loaded image to the MimeBodyPart using a DataHandler.
//        messageBodyPart.setDataHandler(new DataHandler(fds));
        // Set the Content-ID header for the image; it matches the "cid" used in the HTML content.
//        messageBodyPart.setHeader("Content-ID", "<image>");
        // Add the image part to the multipart.
//        multipart.addBodyPart(messageBodyPart);
        // Combine both the email content and image as the content of the MimeMessage.
        message.setContent(multipart);


        
        // Send the email with the embedded image.
        Transport.send(message);

    }
}
