package ca.tecreations.lang.java;

import ca.tecreations.File;
import ca.tecreations.ProjectPath;
import ca.tecreations.Sort;
import ca.tecreations.TypeToType;

import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim
 */
public class GetMainClassesFor {
    private static final String classPathDelimiter = (File.separator.equals("/")) ? ":" : ";";
    File target;
    List<String> list = new ArrayList<>();
    public static boolean debug = false;
    
    public GetMainClassesFor(String target) { 
        this.target = new File(target);
        process();
    }
    
    public List<String> getList() {
        return list;
    }
    
    public void process() {
        if (target.getExtension().equals("jar")) {
            GetMainClassesForJar getter = new GetMainClassesForJar(target.getUnwrapped());
            list = getter.getList();
        } else if (target.isDirectory()) {
            GetMainClassesForClassPath getter = new GetMainClassesForClassPath(target.getUnwrapped());
            list = getter.getList();
        } else {
            throw new IllegalArgumentException("GetMainClassesFor: " + target.getAbsolutePath() + " : Not a .jar or directory.");
        }
    }
}
