package ca.tecreations.components;

import ca.tecreations.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 *
 * @author Tim
 */
public class StatusCommand extends JPanel {
    Status status;
    JTextField command = new JTextField(32);
    GridBagConstraints gbc = new GridBagConstraints();
    
    public StatusCommand(Status status) {
        this.status = status;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        add(new JLabel("Command: "),gbc);

        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 12; 
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 1.0;
        add(command,gbc);
        
    //    command.addActionListener(status);
    }
    
    public void addActionListener(ActionListener al) {
        command.addActionListener(al);
    }
    
    public JTextField getCommand() { return command; }
    
    public String getCommandText() { return command.getText(); }
    
    public void removeActionListener(ActionListener al) {
        command.removeActionListener(al);
    }
    
    public void setText(String text) {
        command.setText(text);
    }
    
}
