package ca.tecreations.apps.javacompiler;

import ca.tecreations.TecData;
import ca.tecreations.Platform;
import ca.tecreations.Properties;
import ca.tecreations.ProjectPath;
import ca.tecreations.SystemTool;
import ca.tecreations.lang.java.GetClassPathFor;
/**
 * 
 * @author tim  
 */   
public class JavaCompilerController {
    public static final SystemTool tool = new SystemTool();
    public static final JavaCompilerController instance = new JavaCompilerController();
    public static Process process; 
    public static long pid = TecData.UNSET;
    
    public static void launch() {
        tool.spawn("java -cp " + new GetClassPathFor(ProjectPath.getSourceJarPath()).getResult() + " " + JavaCompiler.class.getName(),true);
        while (process == null) {
            Platform.sleep(125);
            process = tool.getProcess();
        }
        Properties properties = JavaCompiler.getProperties();
        properties.set("pid",process.pid());
        System.out.println("JCC.launch(): Launched from: " + JavaCompiler.instance.getRuntimePath()); // this should print [path.to]<user>downlads/tecversion.jar
    }
    
    public static boolean isAlive() { return process != null && process.isAlive(); }
    
    public static void main(String[] args) {
        launch();
        //properShutdown();
    }
     
    public static void properShutdown() {
        Properties properties = JavaCompiler.getProperties();
        properties.set(JavaCompiler.SHUTDOWN,true);
    }
    
} 
