package ca.tecreations.apps.filetool;

import ca.tecreations.File;
import ca.tecreations.Pair;
import ca.tecreations.Platform;
import ca.tecreations.StringTool;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;
import ca.tecreations.components.JobProgressDialog;
import ca.tecreations.components.ProgressDialog;
import ca.tecreations.net.backup.TLSClient_TVS12;

import java.util.List;
/**
 *
 * @author Tim
 */
public class Put extends Thread {
    FileTool app;
    TextFile log;
    TLSClient_TVS12 dstClient;
    String srcRoot;
    List<String> names;
    Long size;
    String dstPath;
    String unwrappedDst;
    
    public Put(FileTool app,TextFile log, TLSClient_TVS12 dstClient,String srcRoot, String srcPath, List<String> names, Long size, String dst) {
        this.app = app;
        this.log = log;
        dstClient.setLog(log);
        doLogAction("Put: host: " + dstClient.getHostName() + " size: " + size + " srcRoot: " + srcRoot + " dst: " + dst + " names(" + names.size() + "): " + names);
        this.srcRoot = srcRoot;
        this.dstClient = dstClient;
        this.names = names;
        this.size = size;
        this.dstPath = dst;
        unwrappedDst = StringTool.getUnwrapped(dstPath);
    }
    
    public void doLogAction(String msg) {
        if (log != null) log.add(msg);
        else System.out.println(msg);
    }
    
    public Pair getDirsAndFiles(List<String> names) {
        int dirs = 0;
        int files = 0;
        for(int i = 0; i < names.size();i++) {
            String unwrapped = StringTool.getUnwrapped(names.get(i));
            if (unwrapped.endsWith("/") || unwrapped.endsWith("\\")) {
                dirs++;
            } else {
                files++;
            }
            doLogAction("Name: " + names.get(i) + " dirs: " + dirs + " files: " + files);
        }
        return new Pair(dirs,files);
    }
    
    public String getItemCount(Pair pair) {
        String data = "";
        int dirs = (Integer)pair.getLeft();
        int files = (Integer)pair.getRight();
        if (dirs > 0) {
            if (dirs > 1) {
                data += " " + dirs + " Directories ";
            } else {
                data += " 1 Directory ";
            }
            if (files > 0) {
                if (files > 1) {
                    data += " and " + files + " Files";
                } else {
                    data += " and 1 File";
                }
            }
        } else {
            data += " " + files + " Files";
        }
        return data;
    }
    
    public void run() {
        dstClient.mkdirs(dstPath);
        
        // process for single item
        if (names.size() == 1) {
            String target = StringTool.getUnwrapped(names.get(0));
            File src = new File(target);
            if (TecData.isDir(target)) {
                ProgressDialog itemProgress = app.getProgressDialog();
                if  (app != null) app.setProgress(itemProgress);
                itemProgress.setTitle("Put: 1 Directory: " + src.getName()); 
                itemProgress.setVisible(true);
                doLogAction("Put: putDirectory(1): size: " + size +  " srcRoot: " + srcRoot + " src: " + target + " dst: " + dstPath);
                dstClient.startJob(size);
                String subPath = src.getDeepestDirectory().getName() + File.separator;
                dstClient.putDirectory(log,srcRoot,subPath,StringTool.getDoubleQuoted(dstPath),itemProgress);
                itemProgress.setVisible(false);
            } else { 
                ProgressDialog itemProgress = app.getProgressDialog();
                if (app != null) app.setProgress(itemProgress);
                String newDst = StringTool.getDoubleQuoted(unwrappedDst + src.getName());
                itemProgress.setVisible(true);
                doLogAction("Put: putFile(1): src: " + target + " dst: " + newDst);
                dstClient.putFile(log,StringTool.getDoubleQuoted(target),newDst,itemProgress);
                itemProgress.setVisible(false);
            } 
        } else {
            JobProgressDialog jobProgress = app.getJobProgressDialog();
            if (app != null) app.setProgress(jobProgress);
            jobProgress.setVisible(true);
            Platform.sleep(250); // give the user time to read the message
            dstClient.startJob(size);
            
            Pair vals = getDirsAndFiles(names);
            String title = "Put:";
            title += getItemCount(vals);
            jobProgress.setTitle(title);

            for(int i = 0; i < names.size();i++) {
                String target = names.get(i);
                File src = new File(names.get(i));
                String unwrappedSrc = src.getUnwrapped();
                String srcPath = src.getDeepestDirectory().getParent().getAbsolutePath();
                if (TecData.isDir(target)) {
                    doLogAction("Put: putDirectory(2) srcRoot: " + srcRoot + " src: " + srcPath + " dst: " + dstPath);
                    String subPath = src.getDeepestDirectory().getName() + File.separator;
                    jobProgress.setJob("Directory: " + src.getName());
                    dstClient.putDirectory(log,srcRoot,subPath,dstPath,jobProgress);
                    if (app != null) app.refreshLast();
                } else {
                    String newDst = StringTool.getDoubleQuoted(unwrappedDst + src.getName());
                    doLogAction("Put: putFile(2) src: " + target + " dst: " + newDst);
                    jobProgress.setJob("File: " + src.getName());
                    dstClient.putFile(log,target,newDst,jobProgress);
                }
            }
            jobProgress.setVisible(false);
        }
        if (app != null) app.refreshLast();
    }
    
}
