package ca.tecreations.net;

import ca.tecreations.*;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Tim
 */
public class Server_Blacklist {
    TextFile blacklist = new TextFile(ProjectPath.getNetConfigPath() + "clients.blacklist");

    
    public void add(String ip) {
        ip = ip.trim();
        List<String> lines = blacklist.getLines();
        for(int i = 0; i < lines.size();i++) {
            if (lines.get(i).equals(ip)) {
                return;
            }
        }
        blacklist.add(ip);
    }
    
    public boolean contains(String ip) {
        List<String> ips = blacklist.getLines();
        for (int i = 0; i < ips.size(); i++) {
            if (ips.get(i).equals(ip)) {
                return true;
            }
        }
        return false;
    }

    public void erase() {
        blacklist.setLines(new ArrayList<String>());
    }
    
    public void print() {
        System.out.println("---------------");
        blacklist.print();
    }
    
    public void remove(String ip) {
        List<String> lines = blacklist.getLines();
        for(int i = 0; i < lines.size();i++) {
            if (lines.get(i).equals(ip)) {
                lines.remove(i);
                blacklist.setLines(lines);
            }
        }
    }
    
    public static void main(String[] args) {
        Server_Blacklist blacklist = new Server_Blacklist();
        blacklist.print();
        blacklist.erase();
        blacklist.print();
        blacklist.add("123.45.67.89");
        blacklist.add("127.0.0.1");
        blacklist.print();
        blacklist.remove("123.45.67.89");
        blacklist.print();
    }
}
