package ca.tecreations.components;

import java.awt.event.*;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.List;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
/**
 *
 * @author Tim
 */
public class MultiLineMessageDialog extends JDialog implements ActionListener {
    JFrame app;
    List<JLabel> jlabels;
    JButton ok = new JButton("OK");
    Timer timer = null;
    
    public MultiLineMessageDialog(JFrame app, List<String> labels) {
        super(app,"Message",true);
        this.app = app;
        setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        setLayout(new GridLayout(labels.size() + 1,1));
        for(int i = 0;i < labels.size();i++) {
            JLabel label = new JLabel(labels.get(i));
            label.setBorder(new EmptyBorder(5,5,5,5));
            add(label);
        }
        JPanel buttons = new JPanel(new FlowLayout());
        buttons.add(ok);
        add(buttons);
        ok.addActionListener(this);
        pack();
        setLocationRelativeTo(app);
        setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        dispose();
    }
    
    public void setCloseTimer(long millis) {
        timer = new Timer(1000,this);
        timer.start();
    }
    
    public void setTitle(String title) {
        super.setTitle(title); // the problem with this snippet is that the title
        // doesn't show completely, it will get cut off if the width is not >= the
        // width of the title plus any buttons in the dialog
        // so we actually need something similar to SystemTokenPainter to compute the
        // width of the text, set the dialog box size accordingly, and, if need be,
        // setLocationRelative to "?? frame/app/window?" Pointing at a Point.
        // something like SystemTray
    }
}
