package ca.tecreations.apps;

import ca.tecreations.File;
import ca.tecreations.ProjectPath;
import ca.tecreations.SystemTool;
import ca.tecreations.TecData;
import ca.tecreations.lang.java.GetClassPathFor;

/**
 *
 * @author tim
 */
public class BuildProject {
    
    public static void main(String[] args) {
        String prjName = TecData.selectProjectDir();
        System.out.println("Project: " + prjName);
        System.out.println("ProjectsHome: " + ProjectPath.PROJECTS_HOME);
        File classPath = new File(ProjectPath.PROJECTS_HOME + prjName + File.separator);
        process(classPath,classPath.getUnwrapped());
    }
    
    public static void process(File dir, String root) {
        String cmd = "javac -cp " + new GetClassPathFor(root).getResult();
        String subPath = File.getSubPath(dir.getUnwrapped(),root);
        File[] entries = dir.tecListFiles();
        if (entries != null) {
            new SystemTool().runAndOutput(cmd + 
                             " --source " + SystemTool.TARGET_JAVA_VERSION + 
                             " --target " + SystemTool.TARGET_JAVA_VERSION +
                             " --system \"" + System.getProperty("java.home") + "\"" +
                             " " + root + subPath + "*.java",true);
            for(int i = 0; i < entries.length;i++) {
                if (entries[i].isDirectory()) {
                    process(entries[i],root);
                }
            }
        }
    }
    
}
