package ca.tecreations;


import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author tim
 */
public class Pair { 
    Object first;
    Object second;
    List<File> dirs; 
    List<File> files;
    
    public Pair(String absPath) {
        this(new File(absPath));
    }
     
    public Pair(File root) {
        dirs = new ArrayList<>();
        files = new ArrayList<>();
        List<File> list = root.getListAll();
        File f;
        if (list != null) {
            for(int i = 0; i < list.size();i++) {
                f = list.get(i);
//                System.out.println(f.getAbsolutePath() + " : isDir: " + f.isDirectory());
                if (f.isDirectory()) {
                    dirs.add(new File(f.getAbsolutePath()));
                }
                else files.add(f);
            }
            dirs = Sort.sortToListFile(dirs);
            files = Sort.sortToListFile(files);
        } 
    }
    
    public Pair(List<String> entries) {
        String target;
        for(int i = 0;i < entries.size();i++) {
            target = entries.get(i);
            String unwrapped = StringTool.getUnwrapped(target);
            if (unwrapped.endsWith("\\") || unwrapped.endsWith("/")) {
                dirs.add(new File(target));
            } else {
                files.add(new File(target));
            }
        }
        dirs = Sort.sortToListFile(dirs);
        files = Sort.sortToListFile(files);
    }
    
    public Pair(File[] entries) {
        dirs = new ArrayList<File>();
        files = new ArrayList<File>();
        for(int i = 0;i < entries.length;i++) {
            if (entries[i].isDirectory()) dirs.add(entries[i]);
            else files.add(entries[i]);
        }
        dirs = TypeToType.listStringToListFile(
                              Sort.getSortedByName(
                                     TypeToType.toFileArray(dirs)));
        files = TypeToType.listStringToListFile(
                              Sort.getSortedByName(
                                     TypeToType.toFileArray(files)));
    }
    
    public Pair(Object o1, Object o2) {
        first = o1;
        second = o2;
    }
    
    public Object getA() { return first; }
    
    public Object getB() { return second; }

    public List<File> getDirs() {
        return dirs;
    }
    
    public List<File> getFiles() {
        return files;
    }
    
    public Object getFirst() { return first; }
    
    public Object getLeft() { return first; }
    
    public Object getRight() { return second; }
    
    public Object getSecond() { return second; }
    
    public Integer getMin() {
        if (!(first instanceof Integer) && !(second instanceof Integer)) {
            throw new IllegalArgumentException("Pair.getMin: Not Integers");
        }
        Integer l = (Integer)first;
        Integer r = (Integer)second;
        return Math.min(l,r);
    }
    
    public Integer getMax() {
        if (!(first instanceof Integer) && !(second instanceof Integer)) {
            throw new IllegalArgumentException("Pair.getMin: Not Integers");
        }
        Integer l = (Integer)first;
        Integer r = (Integer)second;
        return Math.max(l,r);
    }
    
    
}
