package ca.tecreations;
  
import java.awt.GraphicsEnvironment;
import java.util.List;

/** 
 *
 * @author Tim de Vries
 */
public class Font { 
    public static final String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    public static final int BOLD = java.awt.Font.BOLD;
    public static final int PLAIN = java.awt.Font.PLAIN; 
    public static final int ITALIC = java.awt.Font.ITALIC;
    public static final String SERIF = java.awt.Font.SERIF;
    public static final String SANS_SERIF = java.awt.Font.SANS_SERIF;
    public static final String MONOSPACED = java.awt.Font.MONOSPACED;
    String name;
    int style;
    int size;
    java.awt.Font javaFont;
     
    public Font(String name, String lowerStyle, int size) {
        this.name = name;
        if (lowerStyle.contains("bold")) style &= Font.BOLD;
        if (lowerStyle.contains("italic")) style &= Font.ITALIC;
        this.size = size;
        javaFont = new java.awt.Font(name,style,size);
    }
    
    public Font(String name, int size, String lowerStyle) {
        this.name = name;
        if (lowerStyle.contains("bold")) style &= Font.BOLD;
        if (lowerStyle.contains("italic")) style &= Font.ITALIC;
        this.size = size;
        javaFont = new java.awt.Font(name,style,size);
    }
    
    public Font(String name, int style, int size) {
        this.name = name;
        this.style = style;
        this.size = size;
        javaFont = new java.awt.Font(name,style,size);
    }

    public Font(java.awt.Font font) {
        javaFont = font;
        this.name = font.getName();
        this.style = font.getStyle();
        this.size = font.getSize();
    }
    
    public File getFile() {
        String path = ProjectPath.getFontsPath() + name + "." + getStyleCode(style) + "." + size + ".font";
        return new File(path);
            
    }
    
    public static int getIndex(String name) {
        for(int i = 0; i < names.length;i++) {
            if (names[i].equals(name)) return i;
        }
        return -1;
    }
    
    public java.awt.Font getJavaFont() { return javaFont; }
    
    public String getName() { return name; }
    
    public String getNameForPath() { 
        String name = getName();
        return StringTool.replaceAll(name," ","_");
    }
    
    public static String getName(int index) {
        if (index >= names.length) {
            throw new IllegalArgumentException("font.getName(" + index + ") is greater than names.length: " + names.length);
        }
        return names[index];
    }
    
    public static String[] getNames() {
        return names;
    }

    public int getSize() { return size; }
    
    public Font getSized(int size) {
        Font newFont = new Font(name,style,size);
        return newFont;
    }
    
    public int getStyle() { return style; }
    
    public String getStyleCode() {
        if (style == PLAIN) return "P";
        else if (style == BOLD) return "B";
        else if (style == ITALIC) return "I";
        else if (style == (BOLD | ITALIC)) return "BI";
        return "U";
    }
    
    public static String getStyleCode(int style) {
        if (style == PLAIN) return "P";
        else if (style == BOLD) return "B";
        else if (style == ITALIC) return "I";
        else if (style == (BOLD | ITALIC)) return "BI";
        return "U";
    }
    
    public String getStyleString() {
        return getStyleString(style);
    }
    
    public String getStyleString(int style) {
        if (style == PLAIN) return "PLAIN";
        else if (style == BOLD) return "BOLD";
        else if (style == ITALIC) return "ITALIC";
        else if (style == (BOLD | ITALIC)) return "BOLD_ITALIC";
        return "UNKNOWN";
    }

    public File getUnicodeFilePath(String unicodePlaneHex, String unicodeCodePointHex) {
        String path = ProjectPath.getFontsPath() + "Unicode" + File.separator;
        path += name + "." + size + "." + getStyleCode(style) + "_" + unicodePlaneHex + unicodeCodePointHex + ".font";
        return new File(path);
    }
    
    public Font getWithName(String name) {
        return new Font(name,style,size);
    }
    
    public Font getWithSize(int size) {
        return new Font(name,style,size);
    }
    
    public Font getWithStyle(int style) {
        return new Font(name,style,size);
    }
    
    public static void main(String[] args) {
        for(int i = 0;i < names.length;i++) {
            System.out.println(names[i]);
        }
    }
    
    public void print(int index, List<Point> points) {
        System.out.print(index + ": ");
        for(int i = 0; i < points.size();i++) {
            System.out.print(points.get(i).getAsCSV() + " ");
        }
        System.out.println();
    }
    
    public static void printFontNames() {
        for(int i = 0; i < names.length;i++) {
            System.out.println(names[i]);
        }
    }
 
    public String toString() {
        return "Font [" + name + "," + getStyleString(style) + "," + size + "]";
    }
    
}
