package ca.tecreations.text.ansi;

import ca.tecreations.TColor;
import ca.tecreations.ImageTool;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

/** 
 *
 * @author Tim
 */ 
public class Histogram {

    List<Integer> counts = new ArrayList<>();
    List<Color> colors = new ArrayList<>();

    public Histogram(BufferedImage image) {
        this(ImageTool.extract(image, 0, 0, image.getWidth(), image.getHeight()));
    }

    public Histogram(int[] pixels) {
        Color c;
        for (int i = 0; i < pixels.length; i++) {
            c = new Color(pixels[i]);
            if (!colors.contains(c)) {
                add(c);
            } else {
                increment(c);
            }
        }
    }

    public void add(Color color) {
        counts.add(1);
        colors.add(color);
    }

    public boolean contains(Color color) {
        return colors.contains(color);
    }

    public List<Color> getColors(int count) {
        List<Color> colors = new ArrayList<>();
        for (int i = 0; i < counts.size(); i++) {
            if (counts.get(i) == count) {
                colors.add(this.colors.get(i));
            }
        }
        return colors;
    }

    public int getCount(Color color) {
        int index = colors.indexOf(color);
        return counts.get(index);
    }

    public int getMax() {
        int max = 0;
        for(int i = 0; i < counts.size();i++) {
            max = Math.max(max,counts.get(i));
        }
        return max;
    }
    
    public List<Color> getMaxes() {
        List<Color> list = new ArrayList<>();
        int max = getMax();
        for(int i = 0; i < counts.size();i++) {
            if (counts.get(i) == max) {
                list.add(colors.get(i));
            }
        }
        return list;
    }
    
    public List<Color> getMaxesExcluding(Color bgColor) {
        List<Color> list = new ArrayList<>();
        int max = 0;
        for(int i = 0; i < counts.size();i++) {
            if (!colors.get(i).equals(bgColor)) {
                max = Math.max(max,counts.get(i));
            }
        }
        for(int i = 0; i < counts.size();i++) {
            if (counts.get(i) == max) {
                list.add(colors.get(i));
            }
        }
        return list;
    }
    
    public void increment(Color color) {
        int index = colors.indexOf(color);
        int count = counts.get(index) + 1;
        counts.set(index, count);
    }

}
