package ca.tecreations.db.mysql;

import ca.tecreations.db.mysql.MySQL;
import ca.tecreations.db.mysql.MySQLPassGenerator;

/**
 *
 * @author tim
 */
public class root_SetRootPass {
    
    // to use this, you must start MySQL with --skip-grant-tables
    public root_SetRootPass(MySQL mysql, String pass) {
        mysql.issue("ALTER USER 'root'@'%' IDENTIFIED BY '" + pass + "'",true);
        mysql.flushPrivileges();
    }
    
    public static void main(String[] args) {
        String host = "tecreations.ca";
        int port = 3306;
        String pass = MySQLPassGenerator.getNext(16);
        MySQL mysql = new MySQL(host,port,"root",pass); // here MySQL will ignore the password
        new root_SetRootPass(mysql,pass);
        System.out.println("Root Pass: " + pass);
    }
    
}
