package ca.tecreations.components;

import ca.tecreations.TColor;
import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.TecData;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
import javax.swing.event.*;

/** 
 * 
 * @author Tim
 */ 
public class TFrame extends JFrame
                implements ComponentListener, WindowListener
{
    public static final String SN = TFrame.class.getSimpleName();
    private static final long serialVersionUID = -6814973102322448668L;
    public boolean standalone = false;
    private String tag;
    private Properties properties;
    int oldX = 0;
    int oldY = 0;
    int oldWidth = 0;
    int oldHeight = 0;
    public static boolean debug = false;
    boolean exitOnClose = false;
  
    public static List<TFrame> instances = new ArrayList<>();

    TPanel holder = new TPanel(TColor.LIGHT_GRAY);
    
    public TFrame() {
        super(ProjectPath.getProjectPropsPath(TecData.TEC_VERSION) + SN + ".properties");
    }
    
    public TFrame(Properties properties, String tag) {
        super(properties.getFilename());
        setLayout(new BorderLayout());
        this.properties = properties;
        this.tag = tag;
        instances.add(this);
        finishInstantiation();
    }

    public TFrame(String propertiesPath, String tag) {
        super(propertiesPath);
        setLayout(new BorderLayout());
        properties = new Properties(new File(propertiesPath),false,true);
        while (properties == null) {
            Platform.sleep(64);
        }
        this.tag = tag;
        instances.add(this);
        finishInstantiation();
    }
    
    public void finishInstantiation() {
        addComponentListener(this);
        //addWindowListener(this);
        if (properties.wasCreated()) {
            if (debug) System.out.println("Properties created. Calling TFrame.doInitalSetup");
            doInitialSetup();
        }
        
        // perform window constraints
        Integer w = properties.getInt(tag + "." + TecData.WINDOW_WIDTH);
        Integer h = properties.getInt(tag + "." + TecData.WINDOW_HEIGHT);
        if (w == null) w = 640;
        if (h == null) h = 480;
        int x = (properties.getInt(tag + "." + TecData.WINDOW_X) == null) ? w / 2 - 320 : properties.getInt(tag + "." + TecData.WINDOW_X);
        int y = (properties.getInt(tag + "." + TecData.WINDOW_Y) == null) ? h / 2 - 240 : properties.getInt(tag + "." + TecData.WINDOW_Y);
        
        // values obtained, set to reality
        setLocation(x,y);
        setSize(w,h);
        addWindowListener(this);

        getContentPane().add(holder,BorderLayout.CENTER);
        validate();
    }
    
    public void checkExit() {
        if (exitOnClose) System.exit(0);
        if (standalone) System.exit(0);
    } 
    
    public void close() {
        setVisible(false);
        dispose();
    }
    
    @Override
    public void componentHidden(ComponentEvent e) {}
    
    @Override
    public void componentMoved(ComponentEvent e) {
        if (getLocation().x != oldX || getLocation().y != oldY) {
            properties.read(false);
            properties.set(tag + "." + TecData.WINDOW_X,getLocation().x);
            properties.set(tag + "." + TecData.WINDOW_Y,getLocation().y);
        }
        oldX = getLocation().x;
        oldY = getLocation().y;
    }
 
    @Override
    public void componentResized(ComponentEvent e) {
        int w = getWidth();
        int h = getHeight();
        if (w != oldWidth || h != oldHeight) {
            if (debug) System.out.println("Setting TFrame size: " + w + "," + h);
            properties.read(false);
            properties.set(tag + "." + TecData.WINDOW_WIDTH,w);
            properties.set(tag + "." + TecData.WINDOW_HEIGHT,h);
        }
        oldWidth = w;
        oldHeight = h;
        revalidate();
    }

    @Override
    public void componentShown(ComponentEvent e) {}
    
    public void doInitialSetup() {
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        properties.read(false);
        properties.set(tag + "." + TecData.WINDOW_X, screenWidth / 2 - 320);
        properties.set(tag + "." + TecData.WINDOW_Y, screenHeight / 2 - 240);
        properties.set(tag + "." + TecData.WINDOW_WIDTH,640);
        properties.set(tag + "." + TecData.WINDOW_HEIGHT,480);
    }
    
    public void exit() {
        exit(0);
    }
    
    public void exit(int exitCode) {
       System.exit(exitCode);
    }
    
    public TPanel getHolder() { return holder; }
    
    public Properties getProperties() { return properties; }

    public Integer getWindowHeight() {
        return properties.getInt(tag + "." + TecData.WINDOW_HEIGHT);
    }
     
    public Integer getWindowWidth() {
        return properties.getInt(tag + "." + TecData.WINDOW_WIDTH);
    }
    
    public boolean isStandalone() { return standalone; }
    
    public static void main(String[] args) {
        TFrame app = new TFrame(ProjectPath.INSTANCE.getPropertiesPath() + "TFrame.properties","TFrame");
        app.setVisible(true);
        //app.setExitOnClose(true);
        app.setStandalone(true); 
        Properties props = app.getProperties();
        props.print();
    }

    public static char[] requestPassword(TFrame app) {
        return requestPassword(app,"Enter a password...");
    }

    public static char[] requestPassword(TFrame app,String title) {
        GetPassword requestor = new GetPassword(app,title);
        requestor.toFront();
        return requestor.getPassword();
    }
    
    public void setExitOnClose(boolean flag) {
        exitOnClose = flag;
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
    
    public void setName(String name) {
        this.tag = name;
    }
    
    public void setProperties() {
        Dimension size = getSize();
        properties.read(false);
        properties.set(tag + "." + TecData.WINDOW_WIDTH,size.width);
        properties.set(tag + "." + TecData.WINDOW_HEIGHT,size.height);
    }
    
    public void setProperties(Properties properties) {
        this.properties = properties;
    }
    
    @Override
    public void setSize(int w, int h) {
        properties.read(false);
        properties.set(tag + "." + TecData.WINDOW_WIDTH,w);
        properties.set(tag + "." + TecData.WINDOW_HEIGHT,h);
        super.setSize(w,h);
    }
    
    public void setSize(java.awt.Rectangle r) {
        setSize(r.width - r.x,r.height - r.y);
    }
    
    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }
    
    @Override
    public void setVisible(boolean state) {
        if (state) {
            Integer width = properties.getInt(tag + "." + TecData.WINDOW_WIDTH);
            Integer height = properties.getInt(tag + "." + TecData.WINDOW_HEIGHT);
            if (width == null || height == null) {
                setSize(640,480);
            } else {
                setSize(width,height);
            }
        }
        super.setVisible(state);
    }
    
    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        close();
        checkExit();
    }
    
    @Override
    public void windowClosing(WindowEvent e) {
        close();
        checkExit();
    }
    
    @Override
    public void windowDeactivated(WindowEvent e) {
    }
    
    @Override
    public void windowDeiconified(WindowEvent e) {
    }
    
    @Override
    public void windowIconified(WindowEvent e) {
    }
    
    @Override
    public void windowOpened(WindowEvent e) {
    }
}
 