package ca.tecreations.apps.deploy;

import ca.tecreations.TColor;
import ca.tecreations.Properties;
import ca.tecreations.ProjectPath;
import ca.tecreations.TypeToType;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.net.PKIData;

import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.*;
import java.io.File;

import javax.swing.*;
import javax.swing.event.*;
/**
 *
 * @author Tim de Vries
 */
public class RemoteDeployment extends JPanel implements ActionListener, DocumentListener, ItemListener {
    Deploy deployment;
    JPanel panel = new JPanel(new GridBagLayout());
    JCheckBox active = new JCheckBox("Deploy To Remote Host",false);
    JLabel hostnameLabel = new JLabel("Hostname:");
    JTextField hostname = new JTextField(32);
    JLabel portLabel = new JLabel("Port:");
    JTextField port = new JTextField(5);
    JLabel keystoreLabel = new JLabel("Client Keystore:");
    JTextField keystore = new JTextField(32);
    JButton selectKeystore = new JButton("Select");
    JLabel truststoreLabel = new JLabel("Client Truststore:");
    JTextField truststore = new JTextField(32);
    JButton selectTruststore = new JButton("Select");
    JLabel keystorePassLabel = new JLabel("Keystore Password:");
    JPasswordField keystorePass = new JPasswordField(32);
    JCheckBox showPass = new JCheckBox("Show Password");
    JLabel serverPathLabel = new JLabel("Server Path:");
    JTextField serverPath = new JTextField(32);
    char echoChar = keystorePass.getEchoChar();
    
    public RemoteDeployment(Deploy deployment) {
        this.deployment = deployment;
        if (deployment.getProperties().wasCreated()) {
            doInitialSetup();
        } else {
            getProperties(deployment.getProperties());
        }
        if (hostname.getText().toLowerCase().equals("localhost") ||
            hostname.getText().equals("127.0.0.1")) {
            hostname.setBackground(TColor.red);
        } else {
            hostname.setBackground(TColor.TEC_LIGHT_GREEN);
        }
        setupGUI();
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == selectKeystore) {
            String path = getStore("Select A Keystore");
            if (path != null) {
                keystore.setText(path);
                deployment.getProperties().set(PKIData.REMOTE_KEYSTORE,path);
            }
        } else if (e.getSource() == selectTruststore) {
            String path = getStore("Select A Truststore");
            if (path != null) {
                truststore.setText(path);
                deployment.getProperties().set(PKIData.REMOTE_TRUSTSTORE,path);
            }
        }
    }
    
    public void changedUpdate(DocumentEvent e) {
        validateHost();
        makeAsDir();
        setProperties();
    }
    
    public void clear() {
        keystorePass.setText("");
        deployment.getProperties().set(PKIData.REMOTE_KEYSTORE_PASSWORD,"prompt");
    }
    
    public void doInitialSetup() {
        active.setSelected(false);
        hostname.setText("localhost");
        hostname.setBackground(TColor.red);
        port.setText("52820");
        keystore.setText("$DOCUMENTS_PATH$" + File.separator + "security" + File.separator + "tecreations.jks");
        truststore.setText("$DOCUMENTS_PATH$" + File.separator + "security" + File.separator + "tecreations.jks");
        Boolean makeSecure = deployment.getProperties().getBoolean(Data.MAKE_SECURE);
        if (makeSecure != null && makeSecure) {
            keystorePass.setText("prompt");
        } else {
            keystorePass.setText(deployment.getProperties().get(PKIData.REMOTE_KEYSTORE_PASSWORD));
        }
        serverPath.setText("/home/tim/");
        showPass.setSelected(true);
        setEnabled(false);
        setProperties();
    }
    
    public String getHost() {
        return hostname.getText();
    }
    
    public char[] getKeystorePassword() { return keystorePass.getPassword(); }
    
    public String getPath() {
        return serverPath.getText();
    }

    public String getPort() {
        return port.getText();
    }
    
    public void getProperties(Properties properties) {
        Boolean remoteActive = properties.getBoolean(Data.REMOTE_ACTIVE);
        if (remoteActive == null) active.setSelected(false);
        else active.setSelected(remoteActive);
        setEnabled(active.isSelected());
        hostname.setText(properties.get(PKIData.REMOTE_HOST));
        port.setText(properties.get(PKIData.REMOTE_PORT));
        keystore.setText(properties.get(PKIData.REMOTE_KEYSTORE));
        truststore.setText(properties.get(PKIData.REMOTE_TRUSTSTORE));
        keystorePass.setText(properties.get(PKIData.REMOTE_KEYSTORE_PASSWORD));
        serverPath.setText(properties.get(Data.REMOTE_PATH));
        Boolean _showPass = properties.getBoolean(Data.REMOTE_SHOW_PASS);
        if (_showPass == null) _showPass = false;
        showPass.setSelected(_showPass);
        setEchoChar();
    }
    

    public String getRemoteHost() {
        return hostname.getText();
    }
    
    public String getRemotePath() {
        return serverPath.getText();
    }

    public String getRemotePort() {
        return port.getText();
    }
    
    public String getRemoteServerPath() {
        return serverPath.getText();
    }
    
    public String getServerPath() {
        return serverPath.getText();
    }
    
    public String getStore(String title) {
        JFileChooser chooser = new JFileChooser(); 
        chooser.setCurrentDirectory(new File(ProjectPath.getDocumentsPath()));
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        chooser.setAcceptAllFileFilterUsed(false);
        int retVal = chooser.showOpenDialog(deployment.getTFrame());
        String path = null;
        if (retVal == JFileChooser.APPROVE_OPTION) { 
            path = chooser.getSelectedFile().toString();
        }
        return path;
    } 
    
    public void insertUpdate(DocumentEvent e) {
        validateHost();
        setProperties();
    }
    
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == active) {
            deployment.getProperties().set(Data.REMOTE_ACTIVE,active.isSelected());
            setEnabled(active.isSelected());
        } else if (e.getSource() == showPass) {
            setEchoChar();
            deployment.getProperties().set(Data.REMOTE_SHOW_PASS,showPass.isSelected());
        }
    }
    
    public void makeAsDir() {
        if (serverPath.getText().contains("/")) {
            if (!serverPath.getText().endsWith("/")) serverPath.setText(serverPath.getText() + "/");
        } else {
            if (!serverPath.getText().endsWith("\\")) serverPath.setText(serverPath.getText() + "\\");
        }
    } 
    
    public void paint(Graphics g) {
        super.paint(g);
        //System.out.println("Active: " + active);
        int x1 = 10;
        int y1 = active.getY() + (active.getHeight() / 2) + 1;
        int x2a = 20 + active.getWidth() + 5;
        int x2 = getSize().width - 10;
        int x3 = 10;
        int y3 = getSize().height - 10;
        int x4 = getSize().width - 10;
        //g = panel.getGraphics();
        g.setColor(TColor.GREY);
        g.drawLine(x1,y1,x1 + 5,y1);
        g.drawLine(x2a,y1,x2,y1);
        g.drawLine(x1,y1,x3,y3);
        g.drawLine(x2,y1,x4,y3);
        g.drawLine(x3,y3,x4,y3);
        g.setColor(TColor.LIGHT_GREY);
        g.drawLine(x1 + 1,y1+1,x1 + 5,y1+1);
        g.drawLine(x2a,y1+1,x2 - 1,y1+1);
        g.drawLine(x1+1,y1 + 1,x1+1,y3 - 1);
        g.drawLine(x2+1,y1,x4+1,y3);
        g.drawLine(x3,y3+1,x4 + 1,y3+1);
    }

    public void removeUpdate(DocumentEvent e) {
        validateHost();
        setProperties();
    }
    
    public void secure() {
        keystorePass.setText("prompt");
        deployment.getProperties().set(PKIData.REMOTE_KEYSTORE_PASSWORD,"prompt");
    }
    
    public void setEchoChar() {
        if (showPass.isSelected()) {
            keystorePass.setEchoChar('\0');
        } else {
            keystorePass.setEchoChar(echoChar);
        }
    }
    
    public void setEnabled(boolean state) {
        hostnameLabel.setEnabled(state);
        hostname.setEnabled(state);
        setHostnameBackground();
        portLabel.setEnabled(state);
        port.setEnabled(state);
        keystoreLabel.setEnabled(state);
        keystore.setEnabled(state);
        selectKeystore.setEnabled(state);
        truststoreLabel.setEnabled(state);
        truststore.setEnabled(state);
        selectTruststore.setEnabled(state);
        keystorePassLabel.setEnabled(state);
        keystorePass.setEnabled(state);
        serverPathLabel.setEnabled(state);
        serverPath.setEnabled(state);
        showPass.setEnabled(state);
        setEchoChar();
    }

    public void setHostnameBackground() {
        if (!active.isSelected()) hostname.setBackground(port.getBackground());
        else validateHost();
    }
    
    public void setProperties() {
        Properties properties = deployment.getProperties();
        properties.set(Data.REMOTE_ACTIVE,active.isSelected());
        properties.set(PKIData.REMOTE_HOST,hostname.getText());
        properties.set(PKIData.REMOTE_PORT,port.getText());
        properties.set(PKIData.REMOTE_KEYSTORE,keystore.getText());
        properties.set(PKIData.REMOTE_TRUSTSTORE,truststore.getText());
        Boolean makeSecure = properties.getBoolean(Data.MAKE_SECURE);
        if (makeSecure == null) makeSecure = true;
        if (!makeSecure) {
            properties.set(PKIData.REMOTE_KEYSTORE_PASSWORD,keystorePass.getText());
        } else {
            properties.set(PKIData.REMOTE_KEYSTORE_PASSWORD,"");
        }
        properties.set(Data.REMOTE_PATH,serverPath.getText());
        properties.set(Data.REMOTE_SHOW_PASS,showPass.isSelected());
    }
    
    public void setActive(boolean state) {
        active.setSelected(state);
        setProperties();
    }
    
    public void setHost(String host) {
        hostname.setText(host);
        setProperties();
    }
        
    public void setKeyStore(String path) {
        keystore.setText(path);
        setProperties();
    }
        
    public void setKeyStorePass(char[] storepass) {
        keystorePass.setEchoChar(new JPasswordField().getEchoChar());
        keystorePass.setText(TypeToType.toString(storepass));
        setProperties();
    }
    
    public void setKeyStorePass(String storepass) {
        keystorePass.setEchoChar(new JPasswordField().getEchoChar());
        keystorePass.setText(storepass);
        setProperties();
    }
    
    public void setPath(String path) {
        serverPath.setText(path);
        setProperties();
    }
        
    public void setPort(String port) {
        this.port.setText(port);
        setProperties();
    }
        
    public void setServerPath(String path) {
        setPath(path);
    }

    public void setTrustStore(String path) {
        truststore.setText(path);
        setProperties();
    }
    
    public void setupGUI() {
        setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        
        c = new GridBagConstraints();
        c.gridx = 0;c.gridy = 0;
        c.gridwidth = 1;c.gridheight = 1;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(new SizedPanel(20,20,getBackground()),c);
        


        c = new GridBagConstraints();
        c.gridx = 0;c.gridy = 1;
        c.gridwidth = 1;c.gridheight = 1;
        panel.add(new SizedPanel(10,10,getBackground()),c);
        
        c = new GridBagConstraints();
        c.gridx = 1;c.gridy = 1;
        c.gridwidth = 2;c.gridheight = 1;
        c.fill = GridBagConstraints.NONE;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(hostnameLabel,c);
        
        c = new GridBagConstraints();
        c.gridx = 3;c.gridy = 1;
        c.gridwidth = 1;c.gridheight = 1;
        panel.add(new SizedPanel(10,10,getBackground()),c);
        
        c = new GridBagConstraints();
        c.gridx = 4;c.gridy = 1;
        c.gridwidth = 4;c.gridheight = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.weightx = 1.0;
        panel.add(hostname,c);
        hostname.getDocument().addDocumentListener(this);
        
        
        c = new GridBagConstraints();
        c.gridx = 0;c.gridy = 2;
        panel.add(new SizedPanel(10,10,getBackground()),c);
        
        c = new GridBagConstraints();
        c.gridx = 1;c.gridy = 3;
        c.gridwidth = 2;c.gridheight = 1;
        c.fill = GridBagConstraints.NONE;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(portLabel,c);
        
        c = new GridBagConstraints();
        c.gridx = 3;c.gridy = 2;
        c.gridwidth = 1; c.gridheight = 1;
        panel.add(new SizedPanel(10,10,getBackground()),c);
        
        c = new GridBagConstraints();
        c.gridx = 4;c.gridy = 3;
        c.gridwidth = 4;c.gridheight = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        panel.add(port,c);
        port.getDocument().addDocumentListener(this);
 
        
        
        
        c = new GridBagConstraints();
        c.gridx = 0;c.gridy = 4;
        c.weighty = 1.0;
        panel.add(new SizedPanel(20,20,getBackground()),c);
        
       
        
        
        c = new GridBagConstraints();
        c.gridx = 0;c.gridy = 5;
        c.gridwidth = 1;c.gridheight = 1;
        c.fill = GridBagConstraints.NONE;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(new SizedPanel(10,10,getBackground()),c);
        
        c = new GridBagConstraints();
        c.gridx = 1;c.gridy = 5;
        c.gridwidth = 2;c.gridheight = 1;
        c.fill = GridBagConstraints.NONE;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(keystoreLabel,c);
        
        c = new GridBagConstraints();
        c.gridx = 3;c.gridy = 1;
        c.gridwidth = 1;c.gridheight = 1;
        panel.add(new SizedPanel(10,10,getBackground()),c);
        
        c = new GridBagConstraints();
        c.gridx = 4;c.gridy = 5;
        c.gridwidth = 4;c.gridheight = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        panel.add(keystore,c);
        keystore.getDocument().addDocumentListener(this);

        c = new GridBagConstraints();
        c.gridx = 8;c.gridy = 5;
        c.gridwidth = 2;c.gridheight = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        panel.add(selectKeystore,c);
        selectKeystore.addActionListener(this);
        
        
        
        c = new GridBagConstraints();
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        panel.add(new SizedPanel(15,15,getBackground()),c);



        c = new GridBagConstraints();
        c.gridx = 0;c.gridy = 7;
        c.gridwidth = 1;c.gridheight = 1;
        c.fill = GridBagConstraints.NONE;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(new SizedPanel(10,10,getBackground()),c);
        
        c = new GridBagConstraints();
        c.gridx = 1;c.gridy = 7;
        c.gridwidth = 2;c.gridheight = 1;
        c.fill = GridBagConstraints.NONE;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(keystorePassLabel,c);
        
        c = new GridBagConstraints();
        c.gridx = 3;c.gridy = 1;
        c.gridwidth = 1;c.gridheight = 1;
        panel.add(new SizedPanel(10,10,getBackground()),c);
        
        c = new GridBagConstraints();
        c.gridx = 4;c.gridy = 7;
        c.gridwidth = 4;c.gridheight = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        panel.add(keystorePass,c);
        keystorePass.getDocument().addDocumentListener(this);

        c = new GridBagConstraints();
        c.gridx = 8;c.gridy = 7;
        c.gridwidth = 2;c.gridheight = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        panel.add(showPass,c);
        showPass.addItemListener(this);
            
        
        
        c = new GridBagConstraints();
        c.gridy = 8;
        c.gridwidth = 1;
        c.gridheight = 1;
        panel.add(new SizedPanel(15,15,getBackground()),c);



        c = new GridBagConstraints();
        c.gridx = 0;c.gridy = 9;
        c.gridwidth = 1;c.gridheight = 1;
        c.fill = GridBagConstraints.NONE;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(new SizedPanel(10,10,getBackground()),c);
        
        c = new GridBagConstraints();
        c.gridx = 1;c.gridy = 9;
        c.gridwidth = 2;c.gridheight = 1;
        c.fill = GridBagConstraints.NONE;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(truststoreLabel,c);
        
        c = new GridBagConstraints();
        c.gridx = 3;c.gridy = 9;
        c.gridwidth = 1;c.gridheight = 1;
        panel.add(new SizedPanel(10,10,getBackground()),c);
        
        c = new GridBagConstraints();
        c.gridx = 4;c.gridy = 9;
        c.gridwidth = 4;c.gridheight = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        panel.add(truststore,c);
        truststore.getDocument().addDocumentListener(this);

        c = new GridBagConstraints();
        c.gridx = 8;c.gridy = 9;
        c.gridwidth = 2;c.gridheight = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        panel.add(selectTruststore,c);
        selectTruststore.addActionListener(this);
        
        
        
        c = new GridBagConstraints();
        c.gridy = 10;
        c.gridwidth = 1;
        c.gridheight = 1;
        panel.add(new SizedPanel(15,15,getBackground()),c);
        
        
        

        
        c = new GridBagConstraints();
        c.gridx = 0;c.gridy = 11;
        c.weighty = 1.0;
        panel.add(new SizedPanel(20,20,getBackground()),c);
        
        
        
        
        c = new GridBagConstraints();
        c.gridx = 0;c.gridy = 12;
        c.gridwidth = 1;c.gridheight = 1;
        c.fill = GridBagConstraints.NONE;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(new SizedPanel(10,10,getBackground()),c);
        
        c = new GridBagConstraints();
        c.gridx = 1;c.gridy = 12;
        c.gridwidth = 2;c.gridheight = 1;
        c.fill = GridBagConstraints.NONE;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(serverPathLabel,c);
        
        c = new GridBagConstraints();
        c.gridx = 3;c.gridy = 12;
        c.gridwidth = 1;c.gridheight = 1;
        panel.add(new SizedPanel(10,10,getBackground()),c);
        
        c = new GridBagConstraints();
        c.gridx = 4;c.gridy = 12;
        c.gridwidth = 4;c.gridheight = 1;
        c.fill = GridBagConstraints.BOTH;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(serverPath,c);
        serverPath.getDocument().addDocumentListener(this);

        

        c = new GridBagConstraints();
        c.gridx = 0;c.gridy = 13;
        c.weighty = 1.0;
        panel.add(new SizedPanel(20,20,getBackground()),c);

        
        
         // layout the main panel
        c = new GridBagConstraints();
        c.gridx = 0; c.gridy = 0;
        c.anchor = GridBagConstraints.NORTHWEST;
        c.fill = GridBagConstraints.NONE;
        c.gridwidth = 1;
        c.gridheight = 1;
        add(active,c);
        active.addItemListener(this);
        
            
        c = new GridBagConstraints();
        c.gridx = 0; c.gridy = 1;
        c.fill = GridBagConstraints.BOTH;
        c.gridwidth = 10;
        c.gridheight = 4;
        c.ipadx = 5; c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        add(panel,c);
    }

    public void validateHost() {
        String host = hostname.getText();
        if (host == null) {
            System.err.println("RemoteDeployment.validateHost: null host");
        } else {
            if (host.toLowerCase().equals("localhost")) {
                hostname.setBackground(TColor.red);
            } else if (!host.contains(".")) {
                hostname.setBackground(TColor.red);
            } else {
                hostname.setBackground(TColor.TEC_LIGHT_GREEN);
            }
        }
    }
    
}
