package ca.tecreations.apps.capturetool;

import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.components.TFrame;

import java.awt.*;
import java.awt.image.BufferedImage;
import javax.swing.*;

/**
 * 
 * @author Tim
 */
public class CaptureTool extends TFrame {
    public static CaptureTool instance;
    JScrollPane scroller;
    public CaptureToolDisplay display;
    
    public CaptureTool() {
        super(ProjectPath.getTecreationsPath() + "CaptureTool" + File.separator + 
                          "CaptureTool.properties",CaptureTool.class.getSimpleName());
        instance = this;
        display = new CaptureToolDisplay(this);
        display.captureAndExtract();
        setJMenuBar(new CaptureToolMenuBar(this,display));
        setExitOnClose(true);
        setupGUI();
    } 
    
    public void doCapture(boolean withApp) {
        display.capture(withApp);
    }
    
    public Rectangle getBoxBounds() {
        return display.getBox().getBounds();
    }
    
    public BufferedImage getBoxContents() {
        return display.getBoxContents();
    }
    
    public BufferedImage getCapture() {
        return display.getImage();
    }
    
    public BufferedImage getExtracted() {
        return display.getBoxContents();
    }
    
    public static void launch() {
        instance = new CaptureTool();
        instance.setVisible(true);
    }
    
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            launch();
        });
        while (instance == null) Platform.sleep(125);
        instance.setExitOnClose(true);
    }

    public void maximize() {
        // Ensure GUI updates are performed on the Event Dispatch Thread
        EventQueue.invokeLater(() -> {
            // Maximize the JFrame
            setExtendedState(JFrame.MAXIMIZED_BOTH);
        });
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        scroller.repaint();
    }
    
    public void scrollToBottomLeft() {
        JScrollBar vsb = scroller.getVerticalScrollBar();
        JScrollBar hsb = scroller.getHorizontalScrollBar();
        vsb.setValue(vsb.getMaximum());
        hsb.setValue(hsb.getMinimum());
    }
    
    public void setBoxBounds(int x, int y, int width, int height) {
        display.setBoxBounds(x,y,width,height);
    }

    public void setupGUI() {
        scroller = new JScrollPane(display,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        scroller.getVerticalScrollBar().setUnitIncrement(16);
        setLayout(new BorderLayout());
        add(scroller,BorderLayout.CENTER);
        validate();
        addKeyListener(display);
    }
}
