package ca.tecreations.apps._gui;

import ca.tecreations.FileEntry;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.*;
 
import javax.swing.*;
/**
 *
 * @author tim
 */
public class DialogSetPOSIXFilePermissions extends JDialog implements ActionListener {
    EntriesPanel panel;
    FileEntry entry;
    
    JLabel user = new JLabel("User");
    JCheckBox ur = new JCheckBox("Read");
    JCheckBox uw = new JCheckBox("Write");
    JCheckBox ux = new JCheckBox("Execute");
    
    JLabel group = new JLabel("Group");
    JCheckBox gr = new JCheckBox("Read");
    JCheckBox gw = new JCheckBox("Write");
    JCheckBox gx = new JCheckBox("Execute");
    
    JLabel other = new JLabel("Other");
    JCheckBox or = new JCheckBox("Read");
    JCheckBox ow = new JCheckBox("Write");
    JCheckBox ox = new JCheckBox("Execute");
    
    JPanel buttons = new JPanel(new FlowLayout());
    JButton cancel = new JButton("Cancel");
    JButton ok = new JButton("OK");
    
    public DialogSetPOSIXFilePermissions(EntriesPanel panel, FileEntry entry) {
        this.panel = panel;
        this.entry = entry;
        setTitle("Unix File Permissions : " + entry.getDisplayName());
        setSize(360,160);
        setLayout(new BorderLayout());
        JPanel selectors = new JPanel();
        selectors.setLayout(new GridLayout(4,3));
        selectors.add(user);
        selectors.add(group);
        selectors.add(other);

        selectors.add(ur);
        selectors.add(gr);
        selectors.add(or);

        selectors.add(uw);
        selectors.add(gw);
        selectors.add(ow);

        selectors.add(ux);
        selectors.add(gx);
        selectors.add(ox); 
        add(selectors,BorderLayout.CENTER);
         
        buttons.add(cancel); 
        buttons.add(ok);
        add(buttons,BorderLayout.SOUTH);
        cancel.addActionListener(this);
        ok.addActionListener(this);

        String perms = entry.getPOSIXFilePermissions();
        ur.setSelected(perms.charAt(0) == 'r');
        uw.setSelected(perms.charAt(1) == 'w');
        ux.setSelected(perms.charAt(2) == 'x');

        gr.setSelected(perms.charAt(3) == 'r');
        gw.setSelected(perms.charAt(4) == 'w');
        gx.setSelected(perms.charAt(5) == 'x');

        or.setSelected(perms.charAt(6) == 'r');
        ow.setSelected(perms.charAt(7) == 'w');
        ox.setSelected(perms.charAt(8) == 'x');

    }
    
    public void actionPerformed(ActionEvent e) {
        setVisible(false);
        if (e.getSource() == cancel) {
        } else if (e.getSource() == ok) {
            String perms = "";
            perms += (ur.isSelected() ? "r" : "-");
            perms += (uw.isSelected() ? "w" : "-");
            perms += (ux.isSelected() ? "x" : "-");
            perms += (gr.isSelected() ? "r" : "-");
            perms += (gw.isSelected() ? "w" : "-");
            perms += (gx.isSelected() ? "x" : "-");
            perms += (or.isSelected() ? "r" : "-");
            perms += (ow.isSelected() ? "w" : "-");
            perms += (ox.isSelected() ? "x" : "-");
            String newPerms = panel.setPOSIXFilePermissions(entry,perms);
            entry.setPOSIXFilePermissions(newPerms);
            panel.updateEntry(panel.getSelectedIndex(),entry);
        }
    }
    
}
