package ca.tecreations.apps;

import ca.tecreations.TColor;
import ca.tecreations.TextToken;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.text.TextTokenPainter;
import ca.tecreations.text.TextPoints;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;

/**
 *
 * @author tim
 */
public class ValidatorPanel extends SizedPanel {
    JScrollPane scroller;

    List<TextTokenPainter> lines = new ArrayList<>();
    static TextPoints points = ca.tecreations.TecData.CODE_POINTS;
    static {
        points.setMonospaced(true);
    }
    
    boolean debug = false;
    int maxWidth = 0;
    int maxHeight = 0;
    
    public ValidatorPanel() {
        super(1,1);
        this.setDoubleBuffered(true);
        setupGUI();
    }   

    public void addLine(String text, Color painterColor) {
        TextTokenPainter painter = new TextTokenPainter(points, new TextToken(text), painterColor);
        painter.setBackground(getBackground());
        lines.add(painter);
        JScrollBar hBar = scroller.getHorizontalScrollBar();
        JScrollBar vBar = scroller.getVerticalScrollBar();
        int hWidth = hBar.getSize().width;
        int vHeight = vBar.getSize().height;
        int textWidth = painter.getTextWidth();
        if (maxWidth < textWidth) maxWidth = textWidth;
        maxWidth = Math.max(hWidth, maxWidth);
        maxHeight = Math.max(vHeight,lines.size() * points.getFontSize());
        setSize(maxWidth, maxHeight);
        int panelHeight = lines.size() * points.getFontSize();
        if (panelHeight > vHeight) {
            setLocation(getLocation().x, -(panelHeight - vHeight));
        } else {
            setLocation(getLocation().x,0);
        }
        repaint();
    }

    public int getMaxLines() {
        return getSize().height / points.getFontSize();
    }

    public TextPoints getPoints() { return points; }
    
    public static void main(String[] args) {
        Validator.launch();
    }
    
    public void mouseWheelMoved(MouseWheelEvent e) {
        JScrollBar hsb = scroller.getHorizontalScrollBar();
        JScrollBar vsb = scroller.getVerticalScrollBar();

        if (e.isAltDown()) {
            if (e.getWheelRotation() == 1) {
                hsb.setValue(hsb.getValue() + hsb.getUnitIncrement());
            } else {
                hsb.setValue(hsb.getValue() - hsb.getUnitIncrement());
            }
        } else {
            if (e.getWheelRotation() == 1) {
                vsb.setValue(vsb.getValue() + vsb.getUnitIncrement());
            } else {
                vsb.setValue(vsb.getValue() - vsb.getUnitIncrement());
            }
        }
    }

    public void paint(Graphics g) {
        Dimension size = getSize();
        g.setColor(getBackground());
        g.fillRect(0, 0, size.width - 1, size.height - 1);
        
        int x;
        int y = 0; 
        Color bg = getBackground();
        int fontSize = points.getFontSize();
        System.err.println("Lines: " + lines.size());
        for (int i = 0; i < lines.size(); i++) {
            TextTokenPainter painter = lines.get(i);
            painter.paintAt(g,0, y);
            y += fontSize;
        }
        ca.tecreations.graphics.GraphicsUtil.drawSunken(g, this);
    }
    
    public void setLastLine(String text, Color painterColor) {
        TextTokenPainter painter = new TextTokenPainter(points, new TextToken(text), painterColor);
        painter.setBackground(getBackground());
        lines.set(lines.size() - 1, painter);
        int maxWidth = painter.getTextWidth();
        setSize(maxWidth, lines.size() * points.getFontSize());
    }

    public void setScroller(JScrollPane scroller) {
        this.scroller = scroller;
    }
    
    public void setupGUI() {
        setBackground(TColor.DARK_GREY);
    }
    
}
