package ca.tecreations.apps;

import ca.tecreations.File;
import ca.tecreations.net.Internet; // Web? // Online?
import ca.tecreations.ProjectPath;
import ca.tecreations.TecData;
import ca.tecreations.components.event.ProgressListener;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
 
/*
 * @author Tim
 */
public class Online {
    public static final String SN = Online.class.getSimpleName();
    
    public static void doLogAction(String msg) {
       System.out.println(SN + ".doLogAction: " + msg);
    }

    public static void downloadTecJar() {
        Internet.download_HTTPS(
                "tecreations.ca/ca/tecreations/" + TecData.TEC_VERSION + ".jar",
                ProjectPath.getDownloadsPath() + TecData.TEC_VERSION + ".jar");
    }
    
    public static boolean isNewerJar(String jarName) {
        String onDisk = ProjectPath.getDownloadsPath() + jarName + ".jar";
        String online = "https://tecreations.ca/ca/tecreations/" + jarName + ".jar";
        File file = new File(onDisk);
        String diskModified = "" + file.getTecLastModified();
        String onlineModified = Internet.getLastModified(online);
        doLogAction("diskModified  : " + diskModified);
        doLogAction("onlineModified: " + onlineModified);
        String diskDate = diskModified.substring(diskModified.indexOf("D") + 1,diskModified.indexOf("T"));
        String onlineDate = onlineModified.substring(onlineModified.indexOf("D") + 1,onlineModified.indexOf("T"));
        String diskDT = diskDate + " " + diskModified.substring(diskModified.indexOf("T") + 1, diskModified.indexOf("Z"));
        String onlineDT = onlineDate + " " + onlineModified.substring(onlineModified.indexOf("T") + 1, onlineModified.indexOf("Z"));
        
        doLogAction("DiskDate: " + diskDT);
        doLogAction("OnlineDate: " + onlineDT);
        
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dateOnDisk = null;
        Date dateOnline = null;
        try {
            dateOnDisk = simpleDateFormat.parse(diskDT);
            dateOnline = simpleDateFormat.parse(onlineDT);
        } catch (ParseException pe) {
            doLogAction("ParseException: diskDate: " + diskDate + " onlineDate: " + onlineDate + " pe: " + pe);
        }
        //System.out.println(dateOnDisk + "," + dateOnline + "," + dateOnDisk.before(dateOnline));
        //System.out.println(dateOnDisk + "," + dateOnline + "," + dateOnDisk.equals(dateOnline));
        //System.out.println(dateOnDisk + "," + dateOnline + "," + dateOnDisk.after(dateOnline));
        return dateOnDisk.before(dateOnline);
    }
    
    public static boolean isNewerJars() {
        String onDisk = ProjectPath.getDownloadsPath() + TecData.TEC_VERSION + "_jars.jar";
        String online = "https://tecreations.ca/ca/tecreations/" + TecData.TEC_VERSION + "_jars.jar";
        File file = new File(onDisk);
        String diskModified = "" + file.getTecLastModified();
        String onlineModified = Internet.getLastModified(online);
        //doLogAction(pl,"diskModified  : " + diskModified);
        //doLogAction(pl,"onlineModified: " + onlineModified);
        String diskDate = diskModified.substring(diskModified.indexOf("D") + 1,diskModified.indexOf("T"));
        String onlineDate = onlineModified.substring(onlineModified.indexOf("D") + 1,onlineModified.indexOf("T"));
        String diskDT = diskDate + " " + diskModified.substring(diskModified.indexOf("T") + 1, diskModified.indexOf("Z"));
        String onlineDT = onlineDate + " " + onlineModified.substring(onlineModified.indexOf("T") + 1, onlineModified.indexOf("Z"));
        
        //doLogAction(pl,"DiskDate: " + diskDT);
        //doLogAction(pl,"OnlineDate: " + onlineDT);
        
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dateOnDisk = null;
        Date dateOnline = null;
        try {
            dateOnDisk = simpleDateFormat.parse(diskDT);
            dateOnline = simpleDateFormat.parse(onlineDT);
        } catch (ParseException pe) {
            doLogAction("ParseException: diskDate: " + diskDate + " onlineDate: " + onlineDate + " pe: " + pe);
        }
        //System.out.println(dateOnDisk + "," + dateOnline + "," + dateOnDisk.before(dateOnline));
        //System.out.println(dateOnDisk + "," + dateOnline + "," + dateOnDisk.equals(dateOnline));
        //System.out.println(dateOnDisk + "," + dateOnline + "," + dateOnDisk.after(dateOnline));
        return dateOnDisk.before(dateOnline);
    }
    
    public static void main(String[] args) {
        System.out.println("IsNewerJars: " + isNewerJars());
        downloadTecJar();
        System.out.println("IsNewer: " + isNewerJar(TecData.TEC_VERSION));
        
    }
}
