package ca.tecreations;

import ca.tecreations.StringTool;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Tim
 */
public class TColor extends java.awt.Color {
    
    public static TColor fromString(String value) {
        java.awt.Color color = null;
        if (value != null) {
            String target = value.substring(value.indexOf("[") + 1,value.indexOf("]"));
            List<String> parts = StringTool.explode(target,",");
            String stringA = parts.get(0);
            String stringR = parts.get(1);
            String stringG = parts.get(2);
            String stringB = parts.get(3);
            int a = Integer.parseInt(stringA);
            int r = Integer.parseInt(stringR);
            int g = Integer.parseInt(stringG);
            int b = Integer.parseInt(stringB);
            return new TColor(r,g,b,a);
        }
        return null;
    }

    public static List<TColor> toList(String semiSeparatedValue) {
        List<TColor> colors = new ArrayList<>();
        List<String> list = StringTool.explode(semiSeparatedValue,";");
        String string;
        for (int i = 0; i < list.size(); i++) {
            string = list.get(i).trim();
            if (!string.equals("")) {
                String target = string.substring(7, string.length() - 1).trim();
                //System.out.println("Target: '" + target + "'");
                List<String> parts = StringTool.explode(target, ',');
                int a = Integer.parseInt(parts.get(0));
                int r = Integer.parseInt(parts.get(1));
                int g = Integer.parseInt(parts.get(2));
                int b = Integer.parseInt(parts.get(3));
                colors.add(new TColor(r,g,b,a));
            }
        }
        return colors;
    }

    public static String toSSV(List<TColor> list) {
        String ssv = "";
        for(int i = 0; i < list.size() - 1;i++) {
            ssv += list.get(i).toString() + ";";
        }
        if (list.size() > 0) ssv += list.get(list.size() - 1).toString();
        return ssv;
    }
    
    @Override
    public String toString() {
        return "Color[" + getAlpha() + "," + getRed() + "," + getGreen() + "," + getBlue() + "]";
    }

    
    public int alpha = 0;
    
    public static TColor BLACK = new TColor(java.awt.Color.black.getRGB());
    public static TColor WHITE = new TColor(java.awt.Color.white.getRGB());
    public static TColor BLUE = new TColor(java.awt.Color.blue.getRGB());
    public static TColor GREEN = new TColor(java.awt.Color.green.getRGB());
    public static TColor CYAN = new TColor(java.awt.Color.cyan.getRGB());
    public static TColor DARK_GRAY = new TColor(java.awt.Color.darkGray.getRGB());
    public static TColor DARK_GREY = new TColor(java.awt.Color.darkGray.getRGB());
    public static TColor GRAY = new TColor(java.awt.Color.gray.getRGB());
    public static TColor GREY = new TColor(java.awt.Color.gray.getRGB());
    public static TColor LIGHT_GRAY = new TColor(java.awt.Color.lightGray.getRGB());
    public static TColor LIGHT_GREY = new TColor(java.awt.Color.lightGray.getRGB());
    public static TColor MAGENTA = new TColor(java.awt.Color.magenta.getRGB());
    public static TColor ORANGE = new TColor(java.awt.Color.orange.getRGB());
    public static TColor PINK = new TColor(java.awt.Color.pink.getRGB());
    public static TColor RED = new TColor(java.awt.Color.red.getRGB());
    public static TColor TRANSPARENT = new TColor(-1);
    public static TColor YELLOW = new TColor(java.awt.Color.yellow.getRGB());
    
    // match the java Color constants
    public static TColor black = new TColor(java.awt.Color.black.getRGB());
    public static TColor white = new TColor(java.awt.Color.white.getRGB());
    public static TColor blue = new TColor(java.awt.Color.blue.getRGB());
    public static TColor green = new TColor(java.awt.Color.green.getRGB());
    public static TColor grey = new TColor(java.awt.Color.gray.getRGB());
    public static TColor red = new TColor(java.awt.Color.red.getRGB());
    public static TColor cyan = new TColor(java.awt.Color.cyan.getRGB());
    public static TColor magenta = new TColor(java.awt.Color.magenta.getRGB());
    public static TColor yellow = new TColor(java.awt.Color.yellow.getRGB());
    public static TColor orange = new TColor(java.awt.Color.orange.getRGB());
    public static TColor pink = new TColor(java.awt.Color.pink.getRGB());
    public static TColor light_gray = new TColor(java.awt.Color.lightGray.getRGB());
    public static TColor dark_gray = new TColor(java.awt.Color.darkGray.getRGB());
    public static TColor light_grey = new TColor(java.awt.Color.lightGray.getRGB());
    public static TColor dark_grey = new TColor(java.awt.Color.darkGray.getRGB());
    
    public static TColor DIRTY = new TColor(26,48,78);
    public static TColor BROWN = new TColor(78,48,26);

    public static TColor TEC_ORANGE = new TColor(245,130,32);
    public static TColor TEC_PURPLE = new TColor(75,0,130);
    public static TColor TEC_LIGHT_GREEN = new TColor(0,224,0);
    public static TColor TEC_DARK_GREEN = new TColor(12,82,42);

    public static final TColor TEC_DARK_GREY = new TColor(18,17,16);
    public static final TColor TEC_LIGHT_GREY = new TColor(248,249,250);
    
    public static TColor TEC_SELECTED = new TColor(102,204,255);
    public static TColor DEFAULT_COLOR = TEC_SELECTED;
    public static final TColor GREY_1 = new TColor(15,15,15);      //16
    public static final TColor GREY_2 = new TColor(31,31,31);      //32
    public static final TColor GREY_3 = new TColor(47,47,47);      //48
    public static final TColor GREY_4 = new TColor(63,63,63);      //64
    public static final TColor GREY_5 = new TColor(79,79,79);      //80
    public static final TColor GREY_6 = new TColor(95,95,95);      //96
    public static final TColor GREY_7 = new TColor(111,111,111);   //
    public static final TColor GREY_8 = new TColor(127,127,127);   //
    public static final TColor GREY_9 = new TColor(143,143,143);   //
    public static final TColor GREY_A = new TColor(159,159,159);   //
    public static final TColor GREY_B = new TColor(175,175,175);   //
    public static final TColor GREY_C = new TColor(191,191,191);   //
    public static final TColor GREY_D = new TColor(207,207,207);   //
    public static final TColor GREY_E = new TColor(223,223,223);   //
    public static final TColor GREY_F = new TColor(239,239,239);   //
    public static final TColor GREY_10 = GREY_A;
    public static final TColor GREY_11 = GREY_B;
    public static final TColor GREY_12 = GREY_C;
    public static final TColor GREY_13 = GREY_D;
    public static final TColor GREY_14 = GREY_E;
    public static final TColor GREY_15 = GREY_F;
    public static final TColor GREY_MAX = new TColor(java.awt.Color.white);
    
    //https://chrisyeh96.github.io/2020/03/28/terminal-colors.html                
    public static TColor BRIGHT_BLACK = new TColor(85, 87, 83);
    public static TColor BRIGHT_RED = new TColor(239, 41, 41);
    public static TColor BRIGHT_GREEN = new TColor(138, 226, 52);
    public static TColor BRIGHT_YELLOW = new TColor(252, 233, 79);
    public static TColor BRIGHT_BLUE = new TColor(50, 175, 255);
    public static TColor BRIGHT_MAGENTA = new TColor(173, 127, 168);
    public static TColor BRIGHT_CYAN = new TColor(52, 226, 226);
    public static TColor BRIGHT_WHITE = new TColor(255, 255, 255);
            
    public static final Color DEFAULT_SWING_BG = new javax.swing.JPanel().getBackground();
    public static final Color SWING_DEFAULT_BG = DEFAULT_SWING_BG;
     
    public static final TColor SWING_DEFAULT_BORDER = new TColor(122,138,153,255);
    
    public TColor(int r, int g, int b) {
        super(r,g,b,255);
    }
    
    public TColor(int r, int g, int b, int a) {
        super(r,g,b,a);
    }
    
    public TColor(int rgba) {
        super(rgba);
    }
    
    public TColor(java.awt.Color color) {
        super(color.getRed(),color.getGreen(),color.getBlue(),color.getAlpha());
    }
    
    // END CONSTRUCTORS ---------------------------=============================
    
    public boolean equals(Object o) {
        if (o instanceof TColor) {
            return equals((TColor)o);
        } else if (o instanceof java.awt.Color) {
            return equals((java.awt.Color)o);
        }
        return false;
    }
    
    public boolean equals(TColor c) {
        return c.getAlpha() == getAlpha() && c.getRed() == getRed() && c.getGreen() == getGreen() && c.getBlue() == getBlue();
    }
    
    public boolean equals(java.awt.Color c) {
        return c.getAlpha() == getAlpha() && c.getRed() == getRed() && c.getGreen() == getGreen() && c.getBlue() == getBlue();
    }
    
    public static TColor getRandom() {
        return getRandomColor();
    }
    
    public static TColor getRandomColor() {
        return new TColor(Platform.getRandom(256),Platform.getRandom(256),Platform.getRandom(256));
    }
    
    public static TColor getReverse(TColor c) {
        return new TColor(255 - c.getRed(), 255 - c.getGreen(),255 - c.getBlue());
    }
    
    public static TColor getReverse(java.awt.Color c) {
        return new TColor(255 - c.getRed(), 255 - c.getGreen(),255 - c.getBlue());
    }
    
    public static void main(String[] args) {
        // black
        System.out.println("Color.BLACK");
        System.out.println(TColor.BLACK.toHex());
        
        System.out.println("Color.tec_purple");
        System.out.println(TEC_PURPLE.toString());
        System.out.println(TEC_PURPLE.toHex());
        
        System.out.println("Color.tec_orange");
        System.out.println(TEC_ORANGE.toString());
        System.out.println(TEC_ORANGE.toHex());
        
        // white
        System.out.println("Color.WHITE");
        System.out.println(TColor.WHITE.toHex());
     
        System.out.println("Swing BG: " + DEFAULT_SWING_BG);
        
    }

    public String toExternal() {
        return "Color[" + getAlpha() + "," + getRed() + "," + getGreen() + "," + getBlue() + "]";
    }
    
    public String toHex() {
        int hi_red = getRed() / 16;
        int lo_red = getRed() % 16;
        int hi_green = getGreen() / 16;
        int lo_green = getGreen() % 16;
        int hi_blue = getBlue() / 16;
        int lo_blue = getBlue() % 16;
        
        char hi_red_char = toHex(hi_red);
        char hi_green_char = toHex(hi_green);
        char hi_blue_char = toHex(hi_blue);
        char lo_red_char = toHex(lo_red);
        char lo_green_char = toHex(lo_green);
        char lo_blue_char = toHex(lo_blue);
        
        return "" + hi_red_char + lo_red_char + hi_green_char + lo_green_char + hi_blue_char + lo_blue_char;
    }
    
    public char toHex(int i) {
        if (i > 9) {
            if (i == 10) return 'A';
            if (i == 11) return 'B';
            if (i == 12) return 'C';
            if (i == 13) return 'D';
            if (i == 14) return 'E';
            if (i == 15) return 'F';
        }
        int j = (char)'0' + i;
        return (char)j;
    }
    
    public int toIntARGB() {
        int theInt = 0;
        theInt += ((getAlpha() & 0xFF) << 24);
        theInt += ((getRed() & 0xFF) << 16);
        theInt += ((getGreen() & 0xFF) << 8);
        theInt += (getBlue());
        return theInt;
    }
    
    public String toValue() {
        return getRed() + "," + getGreen() + "," + getBlue() + "," + getAlpha();
    }
    
}
