package ca.tecreations.wip.toy;

import ca.tecreations.interfaces.Paintable;
import ca.tecreations.ImageTool;
import ca.tecreations.Point;
import ca.tecreations.ProjectPath;
import ca.tecreations.components.ImagePanel;
import ca.tecreations.components.Magnifier;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.components.TFrame;
import ca.tecreations.graphics.DrawObject;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 *
 * @author Tim
 */
public class MultiPanel extends SizedPanel implements MouseListener, MouseMotionListener {
    int spacingWidth = 16;
    int spacingHeight = 16;

    List<Paintable> elements = new ArrayList<>();
    HashMap<Integer,ImagePanel> images = new HashMap<>();
    HashMap<Integer,Component> components = new HashMap<>();
    HashMap<Integer,DrawObject> drawObjects = new HashMap<>();

    Color xColor = null;
    boolean debug = false;
    

    boolean isDrawObject = false;
    DrawObject selected = null;

    int lastX = 0;
    int lastY = 0;
    int deltaX = 0;
    int deltaY = 0;
     
    List<Paintable> added = new ArrayList<>();
    
    public MultiPanel() {
        super(100,100);
        setLayout(null);
        addMouseListener(this);
        addMouseMotionListener(this);
    }

    public MultiPanel(Dimension size) {
        super(size);
        setLayout(null);
        addMouseListener(this);
        addMouseMotionListener(this);
    }

    private void addComponent(Paintable a) {
        int index = elements.size();
        elements.add(a);
        components.put(index,(Component)a);
        add((Component)a);  // group add and validate as a block for coding style example
        validate();
        added.add(a);
    }
    
    private void addDrawObject(DrawObject drawObject) {
        int index = elements.size();
        elements.add(drawObject);  
        drawObjects.put(index,drawObject);
        added.add(drawObject);
        repaint();
    }
    
    private void addImage(ImagePanel ip) {
        int index = elements.size();
        elements.add(ip);
        images.put(index,ip);
        add(ip);
        validate();
        added.add(ip);
        repaint();
    }
    
    public void addPaintable(Paintable obj) {
        if (obj instanceof DrawObject) {
            addDrawObject((DrawObject)obj);
        } else if (obj instanceof ImagePanel) {
            addImage((ImagePanel)obj);
        } else {
            addComponent(obj);
        }
        repaint();
    }

    public boolean componentHasPoint(Component c, Point p) {
        Dimension size = c.getSize();
        Point loc = new Point(c.getLocation());
        return (loc.x <= p.x &&
                (loc.x + size.width) > p.x &&
                loc.y <= p.y &&
                (loc.y + size.height) > p.y);
    }

    public void doPainting(Graphics g) {
        System.out.println("MultiPanel.doPainting()");
        Paintable element;
        for(int i = 0; i < elements.size();i++) {
            element = elements.get(i);
            if (element instanceof DrawObject) {
                DrawObject o = (DrawObject)element;
                o.draw(g);
            } else if (element instanceof Component) {
                ((Component) element).paint(((Component)element).getGraphics());
            }
        }
        if (xColor != null) {
            paintX(g);
        }
        if (outlineColor != null) {
            paintOutline(g);
        }
    }
    
    public boolean drawObjectHasPoint(DrawObject drawObject, Point multiPanelPoint) {
        return true;
    }
    
    public void fillBackground(Graphics g) {
        g.setColor(getBackground());
        g.fillRect(0,0,getSize().width,getSize().height);
    }
    
    public DrawObject getDrawObject(int index) {
        if (index + 1 > drawObjects.size()) {
            throw new IllegalArgumentException("getDrawObject: index must be less than drawObjects.size: " + drawObjects.size());
        }
        return drawObjects.get(index);
    }
    
    public int getDX() { return -deltaX; }
    public int getDY() { return -deltaY; }
    
    public BufferedImage getOutputImage() {
        BufferedImage out = ImageTool.getNewBufferedImage(getSize());
        Graphics g = out.getGraphics();
        paint(g);
        return out;
    }
    
    public Object getSelected() { return selected; }
    
    public Point getTecLocation() {
        java.awt.Point loc = getLocation();
        return new Point(loc);
    }

    public static void main(String[] args) {
        TFrame frame = new TFrame(ProjectPath.INSTANCE.getPropertiesPath() + "MultiPanel.properties", "MultiPanelTestFrame");
        frame.add(new MultiPanel());
        frame.setVisible(true);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isControlDown()) {
            new Magnifier(getOutputImage()).setVisible(true);
        }
    }
    
    public void mouseDragged(MouseEvent e) {
        java.awt.Point p = e.getLocationOnScreen();
        if (isDrawObject) {
            int tdx;
            int tdy;
            //if (constrainTo != VERTICAL) tdx = lastX - p.x;
            //else tdx = 0;
            tdx = lastX - p.x;
            //if (constrainTo != HORIZONTAL) tdy = lastY - p.y;
            //else tdy = 0;
            tdy = lastY - p.y;
            if (tdx == 0 && tdy == 0) return;
            deltaX = tdx;
            deltaY = tdy;
            
            int newX = 0;
            int newY = 0;
            if (deltaX > 0) newX -= Math.abs(deltaX);
            if (deltaX < 0) newX += Math.abs(deltaX);
            if (deltaY < 0) newY += Math.abs(deltaY);
            if (deltaY > 0) newY -= Math.abs(deltaY);
            selected.moveBy(newX,newY);
            repaint();
        } 
        lastX = p.x;
        lastY = p.y;
    }
    
    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {}

    public void mouseMoved(MouseEvent e) {
        java.awt.Point p = e.getLocationOnScreen();
        lastX = e.getX();
        lastY = e.getY();
    }
    
    public void mousePressed(MouseEvent e) {
        isDrawObject = false;
        selected = null;
        Point locInComp = new Point(e.getX(),e.getY());
        //System.out.println("LocInComp: " + e.getX() + "," + e.getY());
        for(int i = 0; i < drawObjects.size();i++) {
            //System.out.println("DrawObject[" + i + "]: " + drawObjects.get(i).getName());
            DrawObject obj = (DrawObject) drawObjects.get(i);
            if (obj != null) {
                if (obj.hasPoint(locInComp)) {
                    isDrawObject = true;
                    selected = drawObjects.get(i);
                    break;
                }
            }
        }
        
        java.awt.Point p = e.getLocationOnScreen();
        lastX = p.x;
        lastY = p.y;
        //System.out.println("MultiPanel.mousePressed: isDrawObject: " + isDrawObject);
    }

    public void mouseReleased(MouseEvent e) {}

    public void paint(Graphics g) {
        if (trace) System.out.println("MultiPanel.paint");
        fillBackground(g);
        paintInOrderAdded_ZeroToMax(g);
    }

    public void paintComponent(Graphics g) {
        if (trace) System.out.println("MultiPanel.paintComponent");
        fillBackground(g);
        paintInOrderAdded_ZeroToMax(g);
    }

    public void paintInOrderAdded_ZeroToMax(Graphics g) {
        g.setColor(getBackground());
        g.fillRect(0,0,getSize().width - 1, getSize().height);
        for(int i = 0; i < elements.size();i++) {
            elements.get(i).paintElement(g);
        }
    }
    public void paintOutline(Graphics g) {
        g.setColor(outlineColor);
        g.drawRect(0,0,getSize().width - 1, getSize().height - 1);
    }
    
    public void paintX(Graphics g) {
        g.setColor(xColor);
        g.drawLine(0, 0, getSize().width - 1, getSize().height - 1);
        g.drawLine(0, getSize().height - 1, getSize().width - 1, 0);
    }

    public void repaintComponents() {
        for(int i = 0; i < components.size();i++) {
            components.get(i).repaint();
        }
    }
    
    public void setSpacing(int spacingWidth,int spacingHeight) {
        this.spacingWidth = spacingWidth;
        this.spacingHeight = spacingHeight;
    }
    
    public void setXColor(Color color) {
        xColor = color;
    }
}
