package ca.tecreations.lang.java;

import ca.tecreations.File;
import ca.tecreations.JarReader;
import ca.tecreations.StringTool;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim
 */
public class GetMainClassesForJar {
    boolean debugList = false;
    String jarPath;
    URLClassLoader loader;
    List<String> list = new ArrayList<>();
    
    public GetMainClassesForJar(String jarPath) {
        String unwrapped = StringTool.getUnwrapped(jarPath);
        this.jarPath = unwrapped;
        if (!new File(jarPath).exists() && !new File(jarPath).getExtension().equals("jar")) {
            throw new IllegalArgumentException("GetMainClassesForJar: Invalid path: " + jarPath);
        }
        try { 
            loader = new URLClassLoader(
                          new URL[]{new java.io.File(jarPath).toURI().toURL()},
                          this.getClass().getClassLoader()
                     );
        } catch (MalformedURLException murle) {
            System.out.println("Malformed URL: " + murle);
        }
        JarReader reader = new JarReader(jarPath);
        process(reader);
    }
    
    public List<String> getList() { return list; }
    
    public void process(JarReader reader) {
        List<String> classNames = reader.getClassNames();
        for(int i = 0; i < classNames.size();i++) {
            boolean hasMain = reader.hasMain(loader, classNames.get(i));
            if (debugList) System.out.println("GetMainClassesForJar: " + classNames.get(i) + " : HasMain: " + hasMain);
            if (hasMain) {
                list.add(classNames.get(i));
            }
        }
    }
    
}
