package ca.tecreations.lang.java;

import ca.tecreations.File;
import ca.tecreations.ProjectPath;

import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author tim
 */
public class GetJarTrio {
    List<File> jarFiles = new ArrayList<>();
    List<String> artifacts = new ArrayList<>();
    List<String> versions = new ArrayList<>();
    int maxPathWidth = 0;
    int maxArtifactWidth = 0;
    int maxVersionWidth = 0;
    
    public GetJarTrio(String projectPath) {
        jarFiles = new GetJarFiles(new ProjectPath("GetJarTrio()",projectPath).getProjectDir()).getFiles();
        process();
    }
    
    public GetJarTrio getFromPath(String absPath) {
        GetJarTrio trios = new GetJarTrio(new ProjectPath("GetJarTrio.getFromPath()",absPath).getProjectDir());
        return trios;
    }
    
    public void process() {
        for(int i = 0; i < jarFiles.size();i++) {
            maxPathWidth = Math.max(jarFiles.get(i).getAbsolutePath().length(),maxPathWidth);
            List<String> av = getArtifactAndVersion(jarFiles.get(i));
            artifacts.add(av.get(0));
            versions.add(av.get(1));
            maxArtifactWidth = Math.max(av.get(0).length(),maxArtifactWidth);
            maxVersionWidth = Math.max(av.get(1).length(),maxVersionWidth);
        }
    }
    
    public List<String> getArtifactAndVersion(File jar) {
        List<String> av = new ArrayList<>();
        String name = jar.getFilenameOnly();
        int versionSeparator = getVersionSeparatorIndex(name);
        if (versionSeparator > 0) { // must have at least 1 character for version
            av.add(name.substring(0,versionSeparator));
            av.add(name.substring(versionSeparator + 1));
        } else {
            av.add(name);
            av.add("");
        }
        return av;
    }
    
    public List<String> getArtifacts() { return artifacts; }
    
    public List<File> getFiles() { return jarFiles; }
    
    public int getMaxArtifactWidth() { return maxArtifactWidth; }

    public int getMaxPathWidth() { return maxPathWidth; }
    
    public int getMaxVersionWidth() { return maxVersionWidth; }
    
    public int getVersionSeparatorIndex(String name) {
        if (name.contains("-0")) {
            return name.indexOf("-0");
        } else if (name.contains("-1")) {
            return name.indexOf("-1");
        } else if (name.contains("-2")) {
            return name.indexOf("-2");
        } else if (name.contains("-3")) {
            return name.indexOf("-3");
        } else if (name.contains("-4")) {
            return name.indexOf("-4");
        } else if (name.contains("-5")) {
            return name.indexOf("-5");
        } else if (name.contains("-6")) {
            return name.indexOf("-6");
        } else if (name.contains("-7")) {
            return name.indexOf("-7");
        } else if (name.contains("-8")) {
            return name.indexOf("-8");
        } else if (name.contains("-9")) {
            return name.indexOf("-9");
        } else {
            return -1;
        }
    }
    
    public List<String> getVersions() { return versions; }
    
    public static void main(String[] args) {
        GetJarTrio trios = new GetJarTrio("auth-server-5");
        List<File> files = trios.getFiles();
        List<String> artifacts = trios.getArtifacts();
        List<String> versions = trios.getVersions();
        int maxPath = trios.getMaxPathWidth();
        int maxArtifact = trios.getMaxArtifactWidth();
        int maxVersion = trios.getMaxVersionWidth();
        // show our results
        for(int i = 0; i < files.size();i++) {
            System.out.print(i + ": " + files.get(i).getAbsolutePath());
            int diff = maxPath - files.get(i).getAbsolutePath().length();
            for(int j = 0;j < diff;j++) System.out.print(" ");
            System.out.print(" Artifact: " + artifacts.get(i));
            diff = maxArtifact - artifacts.get(i).length();
            for(int j = 0; j < diff;j ++) System.out.print(" ");
            System.out.println(" Version: " + versions.get(i));
        }
    }
    
}
