package ca.tecreations.components;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class TextStatus extends JPanel {
    JTextField command = new JTextField(32);
    static JTextField line = new JTextField(6);
    static JTextField col = new JTextField(6);
    List<ActionListener> listeners = new ArrayList<>();
    
    public TextStatus() {
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        add(new JLabel("Command: "),gbc);

        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 9;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.weightx = 0.6;
        add(command,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 16;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 0.2;
        add(line,gbc);
        line.setEditable(false);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 18;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.weightx = 0.2;
        add(col,gbc);
        col.setEditable(false);
    }
    
    public JTextField getCommand() { return command; }
    
    public String getCommandText() { return command.getText(); }
    
    public void set(int line, int col) {
        this.line.setText("" + line);
        this.col.setText("" + col);
    }
    
    public void setCol(int col) {
        this.col.setText("" + col);
    }
    
    public void setLine(int line) {
        this.line.setText("" + line);
        this.col.setText("" + col);
    }
}
