package ca.tecreations.components;

import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import ca.tecreations.text.*;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.*;

import javax.swing.*;


/**
 *
 * @author Tim
 */
public class GetSize extends JDialog implements ActionListener {

    JLabel size = new JLabel("Size: ");
    JTextField width = new JTextField(8);
    SizedPanel x;
    GUITextTokenPainter xPainter;
    JTextField height = new JTextField(8);
    JButton set = new JButton("Set");
    
    public GetSize(JFrame app) {
        super(app);
        setTitle("Input a size for the target item...");
        setModal(true);
        setLayout(new FlowLayout());
        add(size);
        add(width);
        add(x);
        xPainter = new GUITextTokenPainter(TecData.ARIAL_P_12,new TextToken(" x "));
        xPainter.setSize(width.getSize());
        add(height);
        add(set);
        validate();
        pack();
        setVisible(true);
    }
    
    @Override
    public void actionPerformed(ActionEvent e) {
        setVisible(false);
    }
    
    public int getHeight() { return Integer.parseInt(height.getText()); }
    
    public Dimension getSize() { return new Dimension(getWidth(),getHeight()); }
    
    public int getWidth() { return Integer.parseInt(width.getText()); }
    
    
    
    public void paint(Graphics g) {
        super.paint(g); // ensure the Swing paint subsystem does it's work?
        xPainter.setLocation(width.getLocation().x + width.getSize().width,width.getLocation().y /* I think, + height - Points.getFontSize() */);
        xPainter.repaint(); // please repaint
    }
    
    public void setActionButtonLabel(String label) {
        set.setText(label);
    }
    
}
