package ca.tecreations.components;

import ca.tecreations.*;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

/**
 *
 * @author Tim
 */
public class ContinueAction extends JDialog implements ActionListener {
    JButton continue_ = new JButton("Continue");
    
    boolean waiting = true;
    
    public ContinueAction(Window w, String title) {
        super(w);
        setTitle(title);
        setSize(480,240);
        add(continue_,BorderLayout.CENTER);
        continue_.addActionListener(this);
        validate();
        pack();
        setLocationRelativeTo(w);
    }


    public ContinueAction(Window w, String title, String msg) {
        super(w);
        setTitle(title);
        setSize(480,240);
        continue_ = new JButton(msg);
        add(continue_,BorderLayout.CENTER);
        continue_.addActionListener(this);
        validate();
        pack();
        setLocationRelativeTo(w);
    }


    
    public void actionPerformed(ActionEvent e) {
        setVisible(false);
        waiting = false;
    }
    
    public boolean amWaiting() { return waiting; }
    
    public static void main(String[] args) {
        TFrame app = new TFrame();
        app.setSize(Platform.getDesktopSize());
        new ContinueAction(app,"ContinueAction Test: main()").setVisible(true);
    }
}
