package ca.tecreations.apps.filetool;

import ca.tecreations.ExceptionHandler;
import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.net.bo.Client;
import ca.tecreations.net.bo.NoTLSConnectionException;
import ca.tecreations.net.bo.PKIData;

/**
 *
 * @author Tim
 */
public class FileTool_Shutdown {
    
    public static void main(String[] args) {
            String propsPath = ProjectPath.getNetConfigPath() + "localhost_client.properties";
            Properties properties = new Properties(propsPath);
            Client client = null;
            try {
                String host = properties.get(PKIData.REMOTE_HOST);
                int port = properties.getInt(PKIData.REMOTE_PORT);
                String keystorePass = properties.get(PKIData.REMOTE_KEYSTORE_PASSWORD);
                char[] ksp;
                if (keystorePass == null || keystorePass.toLowerCase().equals("prompt")) {
                    ksp = Platform.requestPassword(null,"Enter the keystore password for: " + host);
                } else {
                    ksp = keystorePass.toCharArray();
                }
                client = new Client(properties,true,ksp);
                client.shutdown();
            } catch (NoTLSConnectionException ntlsce) {
                ExceptionHandler.handle("FileTool_Shutdown.main", "no TLS connection: " + properties.getFilename(), ntlsce,true);
            }
        
    }

    
}
