package ca.tecreations;

import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author tim
 */
public class ProjectPath {
    public static final String SN = ProjectPath.class.getSimpleName();
    public static final ProtectionDomain pd = ProjectPath.class.getProtectionDomain();
    public static Properties properties = new Properties(getTecPropsPath() + "ProjectPath.properties");
    public static final String PRJS_HOME_CONST = "PROJECTS_HOME";
    public static String PROJECTS_HOME = properties.get(PRJS_HOME_CONST);

    public static final String DOCS_PATH_VAR_LOWER = "$documents_path$";
    public static final String PROJECT_PATH_VAR_LOWER = "$project_path$";
    public static final String PROJECTS_HOME_VAR_LOWER = "$projects_home$";
    public static final String USER_HOME_VAR_LOWER = "$user_home$";
    
    public static final ProjectPath INSTANCE = new ProjectPath(ProjectPath.class.getSimpleName(),getRuntimePath(ProjectPath.class.getProtectionDomain()));

    public static String PROJECT_DIR;
    public static boolean debug = false;

    public ProjectPath(String caller, String absPath) {
        System.out.println(caller + " : Calling ProjectPath(" + absPath + ")");
        PROJECTS_HOME = properties.get(PRJS_HOME_CONST);
        System.out.println("ProjectPath: PROJECTS_HOME: " + PROJECTS_HOME);
        if (PROJECTS_HOME == null) {
            if (Platform.isHeadless()) {
                System.err.println("You must configure PROJECTS_HOME in: " + properties.getFilename());
                System.exit(0);
            } else {
                selectProjectsHome(getDocumentsPath());
            }
        }
        //PROJECT_DIR = PROJECTS_HOME.substring(PROJECTS_HOME.length(), absPath.indexOf(File.separator, PROJECTS_HOME.length() + 1));
        if (absPath.contains("NetBeansProjects")) { // arrives without any sort of wrapping
            int nbIndex = absPath.indexOf("NetBeansProjects");
            int sepIndex = absPath.indexOf(File.separator,nbIndex + 1);
            int endIndex = absPath.indexOf(File.separator,sepIndex+1);
            PROJECT_DIR = absPath.substring(sepIndex + 1,endIndex); // sep+1 == path + File.separator
        } else {
            absPath = StringTool.getUnwrapped(absPath); // remove any wrapping, if necessary
            String unwrappedHome = StringTool.getUnwrapped(PROJECTS_HOME);
            if (!unwrappedHome.endsWith(File.separator)) {
                unwrappedHome += File.separator; // adds the separator
                PROJECTS_HOME = unwrappedHome; 
            }
            PROJECT_DIR = absPath.substring(unwrappedHome.length()); // returns WITH File.separator
        }
    }

/*
        if (target.exists() && target.isDirectory()) {
            File deepestDir = target.getDeepestDirectoryFile();
            File home = new File(deepestDir.getParent());
            //PROJECTS_HOME = home.getUnwrapped();
            PROJECT_DIR = deepestDir.getName();
            String targetUnwrapped = target.getUnwrapped();
            String newTargetPath = targetUnwrapped;
            if (targetUnwrapped.contains("NetBeansProjects")) {
                if (targetUnwrapped.startsWith("/") && File.separator.equals("\\")) {
                    newTargetPath = StringTool.replaceAll(targetUnwrapped, '/', File.separatorChar);
        //        } else {
                    //            System.err.println("ProjectPath(41): targetUnwrapped: " + targetUnwrapped + " : newTargetPath: " + newTargetPath);
                }
                //        System.out.println("absPath: " + new File(absPath).getAbsolutePath());

                int nbIndex = targetUnwrapped.indexOf("NetBeansProjects");
                int sepIndex = targetUnwrapped.indexOf(File.separatorChar, nbIndex + 1);
                //if (properties.get("PROJECTS_HOME") != null) {
                //    PROJECTS_HOME = properties.get("PROJECTS_HOME");
                //} else {
                    // configure PROJECTS_HOME
                List<String> labels = new ArrayList<>();
                labels.add("ProjectPath.PROJECTS_HOME needs to be configured.");
                labels.add("This is where we keep our projects.");
                labels.add(" ");
                labels.add("The data is accessed via ProjectPath.getProjectsHome().");
                labels.add("The data is stored in: " + ProjectPath.getTecPropsPath() + "ProjectPath.properties");
                Platform.multiLineMessage(null, labels);
                //PROJECTS_HOME = Platform.requestDirectory(null, Platform.getRoot(), "Select a Directory for PROJECTS_HOME...");
                //while (PROJECTS_HOME == null || PROJECTS_HOME.equals("")) {
                //    PROJECTS_HOME = Platform.requestDirectory(null, Platform.getRoot(), "Select a Directory for PROJECTS_HOME...");
                //}
                //if (!new File(PROJECTS_HOME).exists()) {
                //    new File(PROJECTS_HOME).mkdirs();
                //}
//                properties.set("PROJECTS_HOME", PROJECTS_HOME);
            //}
                PROJECT_DIR = targetUnwrapped.substring(sepIndex + 1, targetUnwrapped.indexOf(File.separatorChar, sepIndex + 1));
            } else if (targetUnwrapped.contains(":") && (targetUnwrapped.endsWith("/") | absPath.endsWith("\\"))) {
                File file = new File(targetUnwrapped);
                File prjDir = file.getDeepestDirectoryFile();
//                File prjHome = new File(prjDir.getParent());
//                PROJECTS_HOME = prjHome.getUnwrapped();
                PROJECT_DIR = file.getDeepestDirectoryFile().getName();
                if (target.getExtension().equals("jar")) {
                    System.err.println("The concepts of a ProjectPath are not applicable to jars.: " + absPath);
                    System.err.println("Perhaps you want a \"Project\"?");
                }
            } else {
                File deepest = target.getDeepestDirectoryFile();
                File parent = new File(deepest.getParentFile().getAbsolutePath());
//                PROJECTS_HOME = parent.getUnwrapped();
                PROJECT_DIR = deepest.getDeepestDirectoryFile().getName();
            }
//            if (!PROJECTS_HOME.endsWith(File.separator)) {
//                PROJECTS_HOME += File.separator;
//            }
            }
            if (absPath.endsWith(".jar")) {
                PROJECT_DIR = new File(absPath).getFilenameOnly();
            }
//        if (PROJECTS_HOME == null) {
//            PROJECTS_HOME = properties.get(PRJS_HOME_CONST);
//            if (PROJECTS_HOME == null) {
//                selectProjectsHome(getUserHome());
//                properties.set(PRJS_HOME_CONST,PROJECTS_HOME);
//            }
//        }
        System.out.println("ProjectPath(): PROJECTS_HOME: " + PROJECTS_HOME + " PROJECT_DIR: " + PROJECT_DIR);
    }

*/
    
    
    

//    public static ProjectPath newInstance() {
//        return new ProjectPath("ProjectPath.newInstance()",ProjectPath.class.getProtectionDomain());
//    }
    
    public static String getActual(String s) {
        //System.out.println("DocsPath: " + "$DOCUMENTS_PATH$".length()); // 17
        //System.out.println("PrjPath : " + "$PROJECT_PATH$".length());/ / 16
        //System.out.println("PrjsHome: " + "$PROJECTS_HOME$".length()); // 15
        //System.out.println("UserHome: " + "$USER_HOME$".length()); // 12
       
        if (s == null) return null;
        String lower = s.toLowerCase();
        if (lower.startsWith(DOCS_PATH_VAR_LOWER)) {
            s = ProjectPath.getDocumentsPath() + s.substring(17);
        } else if (lower.startsWith(PROJECT_PATH_VAR_LOWER)) {
            s = ProjectPath.getProjectPath() + s.substring(15);
        } else if (lower.startsWith(PROJECTS_HOME_VAR_LOWER)) {
            s = ProjectPath.getProjectsHome() + s.substring(16);
        } else if (lower.startsWith(USER_HOME_VAR_LOWER)) {
            s = ProjectPath.getUserHome() + s.substring(12);
        }
        
        // perform incorrect separator replacement
        String sep = File.separator;
        if (sep.equals("\\")) {
            if (s.contains("/")) s = StringTool.replaceAll(s,"/","\\");
        } else if (s.contains("\\")) s = StringTool.replaceAll(s,"\\","/");
        
        return s;
    }


    public static String getDistPath() {
        return getProjectPath() + "dist" + File.separator;
    }

    public static String getDocumentsPath() {
        return getUserHome() + "Documents" + File.separator;
    }

    public static String getDownloadsPath() {
        return getUserHome() + "Downloads" + File.separator;
    }

    public static String getFontsPath() {
        return getTecreationsPath() + "fonts" + File.separator;
    }

    public static String getJarForProject() {
        return INSTANCE.getDownloadsPath() + INSTANCE.getProjectDir() + ".jar";
    }

    public static String getJarsPath() {
        return getProjectPath() + "jars" + File.separator;
    }

    public static String getLogsPath() {
        return getProjectPath() + "logs" + File.separator;
    }
    
    public static String getNetConfigPath() {
        return getTecPropsPath() + "NetworkConfig" + File.separator;
    }
    
    public String getPathForProject(String prjLabel) {
        String path = PROJECTS_HOME + prjLabel + File.separator;
        return path;
    }

    public static String getPlatformTempDir() {
        if (Platform.isWin()) {
            return "C:\\temp\\";
        } else {
            return "/tmp/";
        }
    }
    
    public String getProjectDir() {
        return PROJECT_DIR;
    }

    public static String getProjectDir(String projectPath) {
        File f = new File(projectPath);
        String projectDir = f.getDeepestDirectoryFile().getName();
        return projectDir;
    }

    public String getProjectDirName(String path) {
        // sanity check
        if (path.contains("\\") && path.contains("/")) {
            throw new IllegalArgumentException("ProjectPath.getProjectDirName: path contains both File.separators: " + path);
        }

        // is it a NetBeansProjects path? 
        String dirName = "";
        if (path.contains("NetBeansProjects")) { // try to specify exactly where
            return getProjectDirFromNetBeansPath(path);
        }

        // process for your IDE here
        return getProjectDirFromProjectsPath(getProjectsHome(), path);
    }

    public static String getProjectDirFromNetBeansPath(String path) {
        int start = 0;
        int end = 0;
        start = path.indexOf(File.separator, path.indexOf("NetBeansProjects") + 1); // the separator after NetBeans
        end = path.indexOf(File.separator, start);
        return path.substring(start, end);
    }

    public static String getProjectDirFromProjectsPath(String prjHome, String path) {
        String prjhome = StringTool.getUnwrapped(prjHome); // ensure we know what we have 
        // ensure prjHome endsWith(File.separator)
        if (prjhome.contains("\\") && prjhome.contains("/")) {
            throw new IllegalArgumentException("getProjectDirFromProjectsPath: cannot contain both File.separator characters: " + prjHome);
        }
        if (path.contains("\\") && path.contains("/")) {
            throw new IllegalArgumentException("getProjectDirFromProjectsPath: cannot contain both File.separator characters: " + path);
        }
        if (!prjhome.endsWith("\\") && !prjhome.endsWith("/")) {
            throw new IllegalArgumentException("getProjectDirFromProjectsPath: prjHome must be a directory: " + prjHome);
        }
        int start = 0;
        start = prjhome.length(); // we already know it ends with a File.separator

        int end = 0;
        if (path.contains("NetBeansProjects")) {
            return getProjectDirFromNetBeansPath(path);
        } else {
            if (path.contains("/")) {
                end = path.indexOf("/", start + 1); // start search after prjHome separator
            } else { // windows
                end = path.indexOf("\\", start + 1);
            }
        }
        return path.substring(start, end);
    }
 
    public static String getProjectPath() {
        /**
         * This may contain 'null', if running from a jar.
         */
        return PROJECTS_HOME + PROJECT_DIR + File.separator;
    }

    public static String getProjectPath(String prjName) {
        return PROJECTS_HOME + prjName + File.separator;
    }
    
    public static String getProjectPathFromNetbeans(String target) {
        System.out.println("Target: " + target);
        String projectDir = "";
        int index = target.indexOf("NetBeansProjects");
        //System.out.println("Index: " + index);
        index += "NetBeansProjects".length() + 1;
        //System.out.println("Index: " + index);
        while (index < target.length() && target.charAt(index) != '\\' && target.charAt(index) != '/') {
            projectDir += target.charAt(index);
            //System.out.println(index + ": " + projectDir + " : " + target.charAt(index));
            index++;
        }
        return getProjectsHome() + projectDir + File.separator;
    }

    public static String getProjectPropsPath(String prjDir) {
        return INSTANCE.getProjectsHome() + prjDir + File.separator + "properties" + File.separator;
    }
    
    public static String getProjectsHome() {
        return PROJECTS_HOME; // this is with a separator, yeah?
    }

    public static String getPropertiesPath() {
        return INSTANCE.getProjectPath() + "properties" + File.separator;
    }

    public static String getRuntimeJar() {
        //System.out.println("Jar: " + getRuntimePath(ProjectPath.class.getProtectionDomain()));
        String jarPath = getRuntimePath(ProjectPath.class.getProtectionDomain());
        PROJECT_DIR = new File(jarPath).getFilenameOnly();
        return jarPath;
    }
    
    public static String getRuntimePath(ProtectionDomain domain) {
        URL url = domain.getCodeSource().getLocation();
        String path = new File(url.getPath()).getUnwrapped();
        if (File.separator.equals("\\")) {
            if (path.charAt(0) == '/'
                    && (path.charAt(1) >= 'A' && path.charAt(1) <= 'Z')
                    && (path.charAt(2) == ':' && path.charAt(3) == '/')) {
                path = path.substring(1);
                path = StringTool.replaceAll(path, "/", "\\");
            }
        }
        if (path.endsWith(File.separator + File.separator)) {
            path = path.substring(0, path.length() - 1);
        } 
        return path;
    }

    public static String getSecurityPath() {
        return getProjectPath() + "security" + File.separator;
    }

    public static String getSecurityPath(String projectPath) {
        return projectPath + "security" + File.separator;
    }

    public static String getSourceJarPath() {
        return getDownloadsPath() + TecData.TEC_VERSION + ".jar";
    }

    /**
     * getSubPath(String inFormOfSlashEndingWithSlash)
     *
     * Example: getSubPath("path/to/element/")
     *
     * @param s the target subPath we want conformed to the Platform.separator
     * @return the subpath, conformed to the current platforms File.separator,
     * Example: linux/mac/solaris : getSubPath("path/to/element/"); -- returns
     * Java String: same contents Windows : getSubPath("path/to/element/"); --
     * returns Java String: "path\\to\\element\\"
     *
     */
    public static String getSubPath(String s) {
        return File.getSubPath(s);
    }

    public static String getTecCursorsPath() {
        return getTecreationsPath() + "cursors" + File.separator;
    }
    
    public static String getTecImagesPath() {
        return getTecreationsPath() + "images" + File.separator;
    }
    
    public static String getTecJarPath() {
        return getDownloadsPath() + TecData.TEC_VERSION + ".jar";
    }

    public static String getTecJarJarsPath() {
        return getDownloadsPath() + TecData.TEC_VERSION + "_jars.jar";
    }

    public static String getTecJarsPath(String project) {
        return getTecreationsPath()
                + "jars" + File.separator
                + project + File.separator
                + "jars" + File.separator;
    }

    public static String getTecPropsPath() {
        return getTecreationsPath() + "properties" + File.separator;
    }

    public static String getTecSourceJarPath() {
        return getDownloadsPath() + TecData.TEC_VERSION + ".jar";
    }

    public static String getTecreationsPath() {
        return getDocumentsPath() + "tecreations" + File.separator;
    }

    public static String getTecreationsSourcePathFromFS() {
        String pathToSource = "";
        if (new File(getDocumentsPath() + TecData.TEC_VERSION).exists()) {
            pathToSource = new File(getDocumentsPath() + TecData.TEC_VERSION) + File.separator;
        } else if (new File(getDownloadsPath() + TecData.TEC_VERSION + ".jar").exists()) {
            pathToSource = getDownloadsPath() + TecData.TEC_VERSION + ".jar" + File.separator;
        } else {
            pathToSource = getRuntimePath(ProjectPath.class.getProtectionDomain());
        }
        return pathToSource;
    }

    public static String getUserHome() {
        String userHome = System.getProperty("user.home");
        if (!userHome.endsWith(File.separator)) {
            userHome += File.separator;
        }
        return userHome;
    }
    
    public static String getUserSecurityPath() {
        return getDocumentsPath() + "security" + File.separator;
    }
    
    public static String getUserTempDir() {
        return getDocumentsPath() + "tec_tmp" + File.separator;
    }
    
    public static boolean isJar() {
        return getRuntimePath(pd).toLowerCase().endsWith(".jar");
    }

    public static void main(String[] args) {
        ProjectPath pp = new ProjectPath("ProjectPath.main",ProjectPath.getProjectPath());
    }
    
    public void print() {
        System.out.println(SN + ": " + this + " : ProjectPath: " + getProjectPath());
    }

    public static void setProjectDir(String dir) {
        PROJECT_DIR = dir;
    }

    public static String selectProjectsHome(String startPath) {
        String prjsHome = Platform.requestDirectory(null, new File(startPath), "Select PROJECTS_HOME Directory...");
        if (prjsHome == null) {
            Platform.message(null,"ProjectPath.selectProjectsHome: PROJECTS_HOME must be specified.");
            PROJECTS_HOME = selectProjectsHome(startPath);
            if (PROJECTS_HOME != null && !PROJECTS_HOME.equals("")) {
                properties.set(PRJS_HOME_CONST,PROJECTS_HOME);
                properties.write();
                System.out.println("Re-reading ProjectPath.properties...");
                properties.read(true);
            }
        } else {
            properties.set(PRJS_HOME_CONST,prjsHome);
            PROJECTS_HOME = prjsHome;
        }
        String unwrapped = StringTool.getUnwrapped(PROJECTS_HOME);
        if (!unwrapped.endsWith(File.separator)) {
            PROJECTS_HOME = unwrapped + File.separator;
        }
        return PROJECTS_HOME; // probably the user wants to add to a path, never wrap within this class.
    }

    public static void setProjectsHome(String dir) {
        if (dir != null) {
            PROJECTS_HOME = StringTool.getUnwrapped(dir);
            properties.set(PRJS_HOME_CONST,PROJECTS_HOME);
            if (!PROJECTS_HOME.endsWith(File.separator)) {
                PROJECTS_HOME += File.separator;
            }
        } else {
            PROJECTS_HOME = null;
            properties.set(PRJS_HOME_CONST,PROJECTS_HOME);
        }
    }
}
