package ca.tecreations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.GeneralSecurityException;

import org.bouncycastle.operator.OperatorCreationException;
/**
 * 
 * @author Tim
 */
public class ExceptionHandler { 
    
    public static String handle(String caller, Exception e) {
        return handle(caller,"",e,false);
    }
    
    public static String handle(String caller, String msg, Exception e, boolean printStackTrace) {
        String output = "";
        if (e instanceof CertificateException) {
            System.err.println(caller + ": " + (msg.equals("") ? "" : msg + " : ") + (CertificateException)e);
            output += "ERR> " + caller + ": " + (msg.equals("") ? "" : msg + " : ") + (CertificateException)e;
        } else if (e instanceof CertificateEncodingException) {
            System.err.println(caller + ": " + (msg.equals("") ? "" : msg + " : ") + (CertificateEncodingException)e);
            output += "ERR> " + caller + ": " + (msg.equals("") ? "" : msg + " : ") + (CertificateEncodingException)e;
        } else if (e instanceof FileNotFoundException) {
            System.err.println(caller + ": file not found: " + (msg.equals("") ? "" : msg + " : ") + (FileNotFoundException)e);
            output += "ERR> " + caller + ": " + (msg.equals("") ? "" : msg + " : ") + (FileNotFoundException)e;
        } else if (e instanceof GeneralSecurityException) {
            System.err.println(caller + ": " + (msg.equals("") ? "" : msg + " : ") + (GeneralSecurityException)e);
            output += "ERR> " + caller + ": " + (msg.equals("") ? "" : msg + " : ") + (GeneralSecurityException)e;
        } else if (e instanceof IOException) {
            System.err.println(caller + ": io exception: " + (msg.equals("") ? "" : msg + " : ") + (IOException)e);
            output += "ERR> " + caller + ": " + (msg.equals("") ? "" : msg + " : ") + (IOException)e;
        } else if (e instanceof KeyStoreException) {
            System.err.println(caller + ": " + (msg.equals("") ? "" : msg + " : ") + (KeyStoreException)e);
            output += "ERR> " + caller + ": " + (msg.equals("") ? "" : msg + " : ") + (KeyStoreException)e;
        } else if (e instanceof NoSuchAlgorithmException) {
            System.err.println(caller + ": io exception: " + (msg.equals("") ? "" : msg + " : ") + (NoSuchAlgorithmException)e);
            output += "ERR> " + caller + ": " + (msg.equals("") ? "" : msg + " : ") + (NoSuchAlgorithmException)e;
        } else if (e instanceof NoSuchProviderException) {
            System.err.println(caller + " : " + (msg.equals("") ? "" : msg + " : ") + (NoSuchProviderException)e);
            output += "ERR> " + caller + ": " + (msg.equals("") ? "" : msg + " : ") + (NoSuchProviderException)e;
        } else if (e instanceof OperatorCreationException) {
            System.err.println(caller + " : " + (msg.equals("") ? "" : msg + " : ") + (OperatorCreationException)e);
            output += "ERR> " + caller + ": " + (msg.equals("") ? "" : msg + " : ") + (OperatorCreationException)e;
        }
        if (printStackTrace) {
            e.printStackTrace();
            output += e.getStackTrace();
        }
        return output;
    }

    
    
    public static String handleIO(String caller, String msg, Exception e, boolean printStackTrace) {
        String output = "";
        if (e instanceof FileNotFoundException) {
            if (e.getMessage().contains("Access is denied")) {
                output += "ERR> " + caller + " : access denied : " + msg;
                if (printStackTrace) e.printStackTrace();
            } else {
                output += "ERR> " + caller + ": file not found: " + msg;
                if (printStackTrace) {
                    e.printStackTrace();
                    output += e.getStackTrace();
                }
            }
        } else if (e instanceof IOException) {
            output += "ERR> " + caller + ": io exception: " + msg + " : " + (IOException)e;
            if (printStackTrace) {
                e.printStackTrace();
                output += e.getStackTrace();
            }
            
        }
        return output;
    }
     
}
