package ca.tecreations.net.tsp;


import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.*;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author tim
 */
public class TecStreamPrinterClient extends Thread {
    public List<TSPCListener> tspcListeners = new ArrayList<>();
    
    public TecStreamPrinterServer tsps;
    
    public TecStreamPrinterClient(TecStreamPrinterServer server) {
        tsps = server;
        openSocket();
        start();
    }

    public TecStreamPrinterServer getServer() { return tsps; }
    
    static Socket clientSocket = null;
    Process process;
    String source;
    static PrintWriter socketOut;
    static BufferedReader obr;
    static BufferedReader ebr;
    boolean running = false;

    public TecStreamPrinterClient(String source) {
        this.source = source;
        openSocket();
    }

    public TecStreamPrinterClient(Process process, String source) {
        this.process = process;
        this.source = source;
        obr = new BufferedReader(new InputStreamReader(process.getInputStream()));
        ebr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        openSocket();
        start();
    }

    public void addTSPCListener(TSPCListener l) {
        if (!tspcListeners.contains(l)) tspcListeners.add(l);
    }
    
    public void brandedErr(String line) {
        socketOut.println("ERR: " + source + ": " + line);
    }
    
    public void brandedOut(String line) {
        socketOut.println("OUT: " + source + ": " + line);
    }
     
    public void err(String line) {
        socketOut.println("ERR: " + line);
    }

    public Process getProcess() {
        return process;
    }

    public static void openSocket() {
        try {
            clientSocket = new Socket(TecStreamPrinterData.host, TecStreamPrinterData.port);
            socketOut = new PrintWriter(clientSocket.getOutputStream(), true);
            System.out.println("Connected: " + TecStreamPrinterData.host + "@" + TecStreamPrinterData.port);
        } catch (UnknownHostException uhe) {
            System.err.println("TSPC: Unknown host: " + TecStreamPrinterData.host + " : " + uhe);
            System.exit(1);
        } catch (IOException ioe) {
            System.err.println("TSPC: getting connection: " + ioe);
            System.exit(1);
        }
    }

    public void out(String line) {
        socketOut.println("OUT: " + line);
    }

    public void removeTSPCListener(TSPCListener l) {
        tspcListeners.remove(l);
    }
    
    public void run() {
        String line = "";
        while (running) {
            try {
                while ((line = obr.readLine()) != null) {
                    socketOut.println("OUT: " + line);
                    for(int i = 0; i < tspcListeners.size();i++) {
                        tspcListeners.get(i).lineAdded("OUT: " + line);
                    }
                }
            } catch (IOException ioe) {
                System.out.println("TecStreamPrinterClient.run: reading: obr: " + ioe);
            }
            try {
                while ((line = ebr.readLine()) != null) {
                    socketOut.println("ERR: " + line);
                    for(int i = 0; i < tspcListeners.size();i++) {
                        tspcListeners.get(i).lineAdded("OUT: " + line);
                    }
                }
            } catch (IOException ioe) {
                System.out.println("TecStreamPrinterClient.run: reading: ebr: " + ioe);
            }
            running = process.isAlive();
        }
    }

    @Override
    public void start() {
        running = true;
        super.start();
    }

    public void stopRunning() {
        running = false;
    }
}
