package ca.tecreations.net.tsp;

import ca.tecreations.*;
import ca.tecreations.net.PKIData;
import ca.tecreations.net.bc.SecurityTool;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.List;


import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

/**
 *
 * @author Tim
 */
public class TLS_TSPC extends Thread {
    public static final String SN = TLS_TSPC.class.getSimpleName();
    Properties properties;
    public int port;
    public String hostname;

    KeyStore keyStore;
    char[] keyStorePass;
    KeyStore trustStore;

    SSLSocket socket = null;
    static BufferedReader obr;

    public boolean debug = false;

    public boolean running = false;
    
    public boolean print = true;
    
    List<TSPCListener> tspcListeners = new ArrayList<>();
    
    SSLContext sslContext; 
    KeyManagerFactory keyMgrFact;
    TrustManagerFactory trustMgrFact;
    SSLSocketFactory fact;
 
    public TLS_TSPC(Properties properties) {
        this.properties = properties;
        this.port = properties.getInt(PKIData.REMOTE_PORT) + 1;
        System.out.println("Port: " + port);
        hostname = properties.get(PKIData.REMOTE_HOST);
        String ksPass = properties.get(PKIData.REMOTE_KEYSTORE_PASSWORD);
        if (ksPass != null) {
            if (ksPass.toLowerCase().equals("prompt")) {
                keyStorePass = Platform.requestPassword(null,"Enter the TLS_TSPC keystore password for: " + hostname);
            } else {
                keyStorePass = ksPass.toCharArray();
            }
        } else {
            keyStorePass = Platform.requestPassword(null,"Enter the TLS_TSPC keystore password for: " + hostname);
        }
        String ksPath = null;
        try {
            ksPath = ProjectPath.getActual(properties.get(PKIData.REMOTE_KEYSTORE));
            keyStore = SecurityTool.openKeyStore(SecurityTool.JKS, ksPath, keyStorePass);
        } catch (UnrecoverableKeyException e) {
            System.out.println(SN + "(): Unrecoverable Key: pass: " + ksPass);
            System.out.println(SN + "(): properties: " + properties.getFilename());
            System.out.println(SN + "(): Keystore missing. Exiting.");
            System.exit(0);
        } catch (Exception e) {
            ExceptionHandler.handle(SN + "()","attempting to get keystore",e,true);
        }
        String tsPath = ProjectPath.getActual(properties.get(PKIData.REMOTE_TRUSTSTORE));
        if (tsPath != null) {
            trustStore = SecurityTool.openTrustStore(SecurityTool.JKS,tsPath);
        }
        if (keyStore == null || trustStore == null) {
            System.out.println(SN + "(): Unable to open keyStore or trustStore. Cannot continue.");
            System.out.println(SN + "(): Keystore: " + keyStore + " Path: " + ksPath);
            System.out.println(SN + "(): Truststore: " + trustStore + " Path: " + tsPath);
            System.out.println(SN + "(): Verify setup and re-run: " + properties.getFilename());
            System.exit(0);
        }
        try {
            sslContext = SSLContext.getInstance(SecurityTool.TLS, SecurityTool.BCJSSE);
            keyMgrFact = KeyManagerFactory.getInstance(SecurityTool.PKIX, SecurityTool.BCJSSE);;
            keyMgrFact.init(keyStore, keyStorePass);
            trustMgrFact = TrustManagerFactory.getInstance(SecurityTool.PKIX, SecurityTool.BCJSSE);
            trustMgrFact.init(trustStore);
            sslContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), null);
            fact = sslContext.getSocketFactory();
        } catch (Exception e) {
            ExceptionHandler.handle(SN + "()",e);
        }
        openSocket();
    }

    public void addTSPCListener(TSPCListener l) {
        if (!tspcListeners.contains(l)) tspcListeners.add(l);
    }
    
   public void erasePassword() {
        for(int i = 0; i < keyStorePass.length;i++) keyStorePass[i] = '\0';
    }
    
    public final String getHostName() {
        return hostname;
    }

    public Properties getProperties() {
        return properties;
    }

    public String getRemoteHost() {
        return properties.get(PKIData.REMOTE_HOST);
    } 

    public static void launch(Properties properties) {
        properties.set(EnvData.ENV, EnvData.DEV);
        TLS_TSPC client = new TLS_TSPC(properties);
    }

    
    public static void main(String[] args) {
        Properties properties = new Properties(ProjectPath.getTecPropsPath() + 
                                               "Client.properties");
        
        //launch(properties);
        TLS_TSPC client = new TLS_TSPC(properties);
    }
    
    public void openSocket() {
        try {
            socket = (SSLSocket) fact.createSocket(properties.get(PKIData.REMOTE_HOST),port);
            obr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        } catch (Exception e) {
            System.err.println(SN + ".openSocket: unable to connect: properties:" + properties.getFilename());
        }
    }
    
    public void removeTSPCListener(TSPCListener l) {
        tspcListeners.remove(l);
    }
    
    public void run() {
        String line = ""; 
        if (socket != null) {
            System.out.println("Server: " + socket.getInetAddress() + " obr: " + obr);
            System.out.println("========================================================================");
        } else {
            System.err.println("Unable to connect to TLS_TSPS: " + properties.get(PKIData.REMOTE_HOST) + ":" + port);
        }
//        try { 
//            PrintWriter out =
//                new PrintWriter(socket.getOutputStream(), true);
//            out.println();
//        } catch (IOException ioe) {
//            System.out.println("Unable to complete handshake.");
//        }
        while (running) {
            try {
                line = obr.readLine();
                if (print) System.out.println(line);
                for(int i = 0;i < tspcListeners.size();i++) {
                    tspcListeners.get(i).lineAdded(line);
                }
            } catch (IOException ioe) {
                System.out.println(SN + ".run: reading: obr: " + ioe);
                running = false;
                System.exit(0);
            }
            Platform.sleep(250);
        }
    }

    @Override
    public void start() {
        running = true;
        super.start();
    }

    public void stopRunning() {
        running = false;
    }

}
