package ca.tecreations.lang.java;

import ca.tecreations.ProjectPath;

// https://stackoverflow.com/questions/1293308/java-api-to-find-out-the-jdk-version-a-class-file-is-compiled-for
import java.io.*;

public class GetClassVersion {
    int major;
    int minor;
    
    public GetClassVersion(String absPath) {
        getClassVersion(absPath);
    }
    
    public int getMajor() {
        return major;
    }
    
    public int getMinor() {
        return minor;
    }
    
    private void getClassVersion(String filename) {
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(filename));
            int magic = in.readInt();
            if (magic != 0xcafebabe) {
                System.err.println("GetClassVersion: Not a class.");
                throw new IllegalArgumentException("Not a .class file.");
            }
            minor = in.readUnsignedShort();
            major = in.readUnsignedShort();
            in.close();
        } catch (IOException ioe) {
           System.out.println("GetClassVersion: " + ioe);
        }
    }
    
    public static void main(String[] args) throws IOException {
        GetClassVersion getter = null;
        for (int i = 0; i < args.length; i++) {
            getter = new GetClassVersion(args[i]);
            System.out.println(args[i] + " : " + getter.getMajor() + "." + getter.getMinor());
        }
        String filename = ProjectPath.INSTANCE.getProjectPath() + "ca" + File.separator + "tecreations" + File.separator + "SystemTool.class";
        getter = new GetClassVersion(filename);
        System.out.println(filename + " : " + getter.getMajor() + "." + getter.getMinor());
        
    }
}
