package ca.tecreations.apps.deploy;

import ca.tecreations.File;
import ca.tecreations.JarWriter;
import ca.tecreations.Pair;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.StringTool;
import ca.tecreations.TypeToType;
import ca.tecreations.time.TimsTime;
import java.util.ArrayList;
import java.util.List;
/**
 *  
 * @author tim
 */
public class Snapshot {
    Properties properties = new Properties(ProjectPath.getTecPropsPath() + "Snapshot.properties");
    public static String snapshotPath = ProjectPath.getProjectsHome();
    static {
        snapshotPath = snapshotPath.substring(0,snapshotPath.length() - 1);
        snapshotPath += ".snapshots" + File.separator;
    }
    String prjSnapshotsPath;

    String projectDir;
    Properties projectProps;
    
    boolean withTime = false;
    
    public Snapshot(String projectPath,boolean withTime) {
        this.withTime = withTime;
        projectDir = ProjectPath.getProjectDir(projectPath);
        projectProps = new Properties(ProjectPath.getPropertiesPath() + "Deploy.properties");
        List<String> excludes = projectProps.getList(Data.PROJECT_PATHS_EXCLUDES);
        
        prjSnapshotsPath = snapshotPath + projectDir + File.separator;
        if (!new File(prjSnapshotsPath).exists()) {
            System.out.println("Making Snapshots Path: " + prjSnapshotsPath);
            new File(prjSnapshotsPath).mkdirs();
        }
        
        int nextIndex = getNextIndex(projectDir);
        List<String> list = getPackingList(projectPath,excludes);
        makeSnapshot(projectPath,projectDir,nextIndex,list);
    }
    
    public int getNextIndex(String projectDir) {
        String prjsHome = StringTool.getUnwrapped(ProjectPath.getProjectsHome());
        //System.out.println("Projects Home: " + prjsHome);
        String path;
        if (prjsHome.endsWith("/") || prjsHome.endsWith("\\")) {
            path = prjsHome.substring(0,prjsHome.length() - 1);
        } else {
            path = prjsHome;
        }
        path += ".snapshots" + File.separator + projectDir + File.separator;
        //System.out.println("Snapshots Path: " + path);
        int lastIndex = 0;
        File[] entries = new File(path).tecListFiles();
        for(int i = 0; i < entries.length;i++) {
            if (entries[i].isFile()) {
                String name = entries[i].getName();
                //System.out.println("Processing: " + name);
                if (name.startsWith(projectDir + "_")) {
                    int index = projectDir.length() + 1;
                    int endIndex;
                    if (name.indexOf("_",index) == -1) {
                        //System.err.println("No TIME");
                        endIndex = name.indexOf(".",index); // just the snapshot index
                    } else {
                        
                        endIndex = name.indexOf("_",index); // has time
                    }
                    //System.out.println("Name: " + name);
                    //System.out.println("Index: " + index);
                    //System.out.println("EndIndex: " + endIndex);
                    String lastIndexStr = name.substring(index,endIndex);
                    //System.out.println("LastIndexString: " + lastIndexStr);
                    lastIndex = Math.max(Integer.parseInt(lastIndexStr),lastIndex);
                    //System.out.println("Index: "  + index + " LastIndex: " + lastIndex);
                }
            }
        }
        return lastIndex + 1;
    }
        
    public List<String> getPackingList(String path, List<String> excludes) {
        List<String> packingList = new ArrayList<>();
        //System.out.println("Path: " + path);
        String sep = File.separator;
        String extension;
        Pair entries = new Pair(new File(path).tecListFiles());
        List<File> dirs = entries.getDirs();
        //System.err.println("Dirs: " +  TypeToType.toString_AbsPaths(dirs));
        List<File> files = entries.getFiles();
        File currentTarget;
        String absPath;
        for(int i = 0; i < files.size();i++) {
            currentTarget = files.get(i);
            absPath = currentTarget.getAbsolutePath();
            extension = currentTarget.getExtension().toLowerCase();
            boolean added = false;
            if (absPath.indexOf(sep + "logs" + sep) == -1) {
                if (!currentTarget.getName().equals(".DS_Store") &&
                    !extension.equals("jar") &&
                    !extension.equals("class") &&
                    !extension.equals("zip")
                ) {
                    packingList.add(absPath);
                    added = true;
                }
            }
            //System.out.println("AbsPath: " + absPath + "added: " + added);
        }
        String name;
        for(int i = 0; i < dirs.size();i++) {
            currentTarget = dirs.get(i);
            name = currentTarget.getName();
            if (name.equalsIgnoreCase("logs")) {
                //next();
            } else {
                if (
                    !name.equalsIgnoreCase("dist") &&
                    !name.equalsIgnoreCase("jars") &&
                    !name.equalsIgnoreCase("logs") &&
                    !name.equalsIgnoreCase("properties") &&
                    !name.equalsIgnoreCase("security") 
                ) {
                    if (!inList(    excludes,currentTarget.getAbsolutePath())) {
                        List<String> list = getPackingList(currentTarget.getAbsolutePath(),excludes);
                        for(int j = 0; j < list.size();j++) packingList.add(list.get(j));
                    }
                }
            }
        }
        return packingList;
    }

    public boolean inList(List<String> wrappedList, String wrappedTarget) {
        for (int i = 0; i < wrappedList.size(); i++) {
            if (new File(wrappedList.get(i)).getUnwrapped().equals(wrappedTarget)) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        Snapshot maker = new Snapshot(ProjectPath.getProjectPath(),true);
    }
    
    public void makeSnapshot(String projectPath, String projectDir, int index, List<String> list) {
        JarWriter jarWriter = null;
        String filename = projectDir + "_" + index;
        if (withTime) {
            TimsTime tt = new TimsTime();
            //System.out.println("TimsTime: "+ tt.toString());
            filename += "_" + tt.getDate() + "_" + tt.getTimeForFilename();
        }
        filename += ".jar";
        System.out.println("Snapshot.makeSnapshot: " + prjSnapshotsPath + filename);
        jarWriter = new JarWriter(prjSnapshotsPath + filename);
        if (jarWriter != null) {
            for (int i = 0; i < list.size(); i++) {
                //System.out.println("List(" + i + "): " + list.get(i));
                jarWriter.addFile(projectPath, new File(list.get(i)));
            }
            jarWriter.close();
        } else {
            System.err.println("Snapshot.makeSnapshot: jarWriter is null");
        }
        System.out.println("Next Index: " + (index+1));
    }
}
