package ca.tecreations.apps.deploy;

import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.components.GroupedPanel;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.*;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.Date;
import javax.swing.*;
import javax.swing.event.*;
/**
 *
 * @author Tim de Vries
 */
public class OutputOptions extends GroupedPanel implements DocumentListener, ItemListener {
    Deploy deployment;
    JTextField prefix = new JTextField(32);
    JCheckBox appendDate = new JCheckBox("Append Date (.yyyy.mm.dd)",false);
    JCheckBox appendTime = new JCheckBox("Append 24 hour time (.tttt)",false);
    JTextField sample = new JTextField(24);
    String date = "";
    String time = "";

    public OutputOptions(Deploy deployment) {
        super("Output Filename");
        this.deployment = deployment;
        if (deployment.getProperties().wasCreated()) {
            doInitialSetup();
        } else { 
            getProperties(deployment.getProperties());
        }
        setupGUI();
    }
    
    public void changedUpdate(DocumentEvent e) {
        sample.setText(getFilename());
        deployment.getCodeSigning().filenameUpdated();
        deployment.getProperties().set(Data.OUTPUT_PREFIX,prefix.getText());    
    }

    public void doInitialSetup() {
        String _prefix = deployment.getProperties().get(Data.OUTPUT_PREFIX);
        if (_prefix == null || _prefix.equals("")) {
            prefix.setText(ProjectPath.PROJECT_DIR);
        }
        sample.setText(getCurrentFilename());
    }
    
    public void filenameUpdated() {
        sample.setText(getCurrentFilename());
    }
    
    public String getCurrentFilename() {
        String filename;
        if (deployment.getCreateJarCheckBoxValue()) filename = getFilename() + ".jar";
        else filename = getFilename() + ".zip";
        return filename;
    }
    
    public String getFilename() {
        String filename = prefix.getText();
        Properties properties = deployment.getProperties();
        Boolean appendDate = properties.getBoolean(Data.OUTPUT_APPEND_DATE);
        Boolean appendTime = properties.getBoolean(Data.OUTPUT_APPEND_TIME);        
        if (appendDate != null && appendTime != null) {
            if (appendDate || appendTime) {
                setDateTime();
            }
            if (appendDate) {
                filename += date;
            }
            if (appendTime) {
                filename += time;
            }
        }
        return filename;
    }
    
    public String getFilenamePrefix() {
        return prefix.getText();
    }
    
    public void getProperties(Properties properties) {
        prefix.setText(properties.get(Data.OUTPUT_PREFIX));
        Boolean date = properties.getBoolean(Data.OUTPUT_APPEND_DATE);
        Boolean time = properties.getBoolean(Data.OUTPUT_APPEND_TIME);
        if (date == null) date = true;
        if (time == null) time = true;
        appendDate.setSelected(date);
        appendTime.setSelected(time);
        sample.setText(getCurrentFilename());
    }
    
    public void insertUpdate(DocumentEvent e) {
        sample.setText(getFilename());
        deployment.getCodeSigning().filenameUpdated();
        deployment.getProperties().set(Data.OUTPUT_PREFIX,prefix.getText());    
    }

    public void itemStateChanged(ItemEvent e) {
        Properties properties = deployment.getProperties();
        properties.setDelayWrite();
        properties.set(Data.OUTPUT_APPEND_DATE,appendDate.isSelected());
        properties.set(Data.OUTPUT_APPEND_TIME,appendTime.isSelected());
        properties.write();
        sample.setText(getCurrentFilename());
        deployment.getCodeSigning().filenameUpdated();
    }
    
    public void removeUpdate(DocumentEvent e) {
        sample.setText(getFilename());
        while (deployment.getCodeSigning() == null) Platform.sleep(125);
        deployment.getCodeSigning().filenameUpdated();
        deployment.getProperties().set(Data.OUTPUT_PREFIX,prefix.getText());    
    }

    public void setDateTime() {
        Timestamp ts = new Timestamp(new Date().getTime());
        String timestamp = "";
        timestamp = ts.toString();
        date = "." + timestamp.substring(0,timestamp.indexOf(' ')).replace('-','.');
        LocalTime now = LocalTime.now();
        int hours = now.getHour();
        int mins = now.getMinute();
        time = ".";
        if (hours < 10) {
            time += "0" + hours;
        } else {
            time += hours;
        }
        if (mins < 10) {
            time += "0" + mins;
        } else {
            time += mins;
        }
    }

    public void setAppendDate(boolean state) {
        appendDate.setSelected(state);
        //setProperties(Deploy.instance.getProperties());
    }
    
    public void setAppendTime(boolean state) {
        appendTime.setSelected(state);
        //setProperties(Deploy.instance.getProperties());
    }
    
    public void setFilenamePrefix(String prefix) {
        this.prefix.setText(prefix);
        deployment.getProperties().set(Data.OUTPUT_PREFIX,prefix);
    }
    
    public void setProperties() {
        Properties properties = deployment.getProperties();
        properties.set(Data.OUTPUT_PREFIX,prefix.getText());
        properties.set(Data.OUTPUT_APPEND_DATE,appendDate.isSelected());
        properties.set(Data.OUTPUT_APPEND_TIME,appendTime.isSelected());
    }
    
    public void setupGUI() {
        setLayout(new GridBagLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0; c.gridy = 0;
        c.gridwidth = 2;c.gridheight = 1;
        c.fill = GridBagConstraints.NONE;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(new JLabel("Prefix:"),c);
        
        c = new GridBagConstraints();
        c.gridx = 2;c.gridy = 0;
        c.gridwidth = 8;c.gridheight = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.anchor = GridBagConstraints.CENTER;
        c.weightx = 1.0;
        panel.add(prefix,c);
        prefix.getDocument().addDocumentListener(this);
        
        c = new GridBagConstraints();
        c.gridx = 0;c.gridy = 4;
        c.gridwidth = 4;c.gridheight = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(appendDate,c);
        appendDate.addItemListener(this);

        c = new GridBagConstraints();
        c.gridx = 0;c.gridy = 5;
        c.gridwidth = 4;c.gridheight = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(appendTime,c);
        appendTime.addItemListener(this);
        
        c = new GridBagConstraints();
        c.gridx = 0;c.gridy = 6;
        c.gridwidth = 2; c.gridheight = 1;
        c.anchor = GridBagConstraints.LINE_START;
        panel.add(new JLabel("Sample Filename:"),c);
        
        c = new GridBagConstraints();
        c.gridx = 2;c.gridy = 6;
        c.gridwidth = 8; c.gridheight = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.anchor = GridBagConstraints.CENTER;
        panel.add(sample,c);
        sample.setEditable(false);
        sample.setText(getCurrentFilename());
        
        c = new GridBagConstraints();
        c.gridx = 0; c.gridy = 0;
        c.fill = GridBagConstraints.BOTH;
        c.insets = new Insets(20,20,20,20);
        c.ipadx = 5; c.ipady = 5;
        c.weightx = 1.0;
        add(panel,c);
    }
}
