package ca.tecreations.apps._actions;

import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import ca.tecreations.components.Button;
import ca.tecreations.text.*;

import java.awt.Graphics;
import java.awt.event.*;


/**
 *
 * @author tim
 */
public class EnvButton extends Button {
    String env = "P";
    SystemTokenPainter painter;
    
    public EnvButton() { 
    } 
 
    public String getTag() {
        return env;
    }
    
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        toggle();
        repaint();
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        painter = new SystemTokenPainter(TecData.LG_CODE_POINTS,new TextToken(env));
        int x = ((getSize().width - painter.getTextWidth()) / 2);
        int y = ((getSize().height - painter.getFontSize()) / 2);
        painter.paintAt(g,x,y);
    }
    
    public void setTag(String s) {
        env = s;
    }
    
    public void toggle() {
        if (env.equals("P")) env = "D";
        else env = "P";
        repaint();
    }
}
