package ca.tecreations;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.PrintStream;
/**
 *
 * @author tim
 */
public class StreamPrinter extends Thread {
    Process process;
    PrintStream out;
    PrintStream err;
    BufferedReader obr;
    BufferedReader ebr;
    
    public StreamPrinter(Process process, PrintStream out, PrintStream err) {
        this.process = process;
        this.out = out;
        this.err = err;
        obr = new BufferedReader(new InputStreamReader(process.getInputStream()));
        ebr = new BufferedReader(new InputStreamReader(process.getInputStream()));
    }

    // it's already being extended. We need to provide data access
    public Process getProcess() { return process; }
    
    public BufferedReader getOBR() { return obr; }
    
    public BufferedReader getEBR() { return  ebr; }
 
    public void run() {
        String line = "";
        while (process.isAlive()) {
            try {
                line = obr.readLine();
            } catch (IOException ioe) {
                System.out.println("StreamPrinter.run: reading: obr: " + ioe);
            }
            if (line != null) {
                out.println(line);
                // optionally add token
                line = null;
            }
            try {
                line = ebr.readLine();
            } catch (IOException ioe) {
                System.out.println("StreamPrinter.run: reading: ebr: " + ioe);
            } 
            if (line != null) {
                err.println(line);
                // optionally add token
                line = null;
            }
        }
    }
    
    
}
