package ca.tecreations;


import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List; 

/**
 *
 * @author tim
 */
public final class FindInComputer {
    public static final String SN = FindInComputer.class.getSimpleName();
    int item = 0;
    public List<String> output = new ArrayList<>();
    
    String needle;
    
    public static boolean debug = false;
    public static boolean trace = true;
    
    // we conform to lowercase for needle and haystack
    
    public FindInComputer(String needle) {
        this.needle = needle.toLowerCase();
        System.out.println("Searching for: " + needle);
        //if (TecData.TSPC != null) TecData.TSPC.out("FindInComputer(): Searching for: " + needle);
        
        File[] roots = File.tecListRoots();
        for(int i = 0; i < roots.length;i++) {
            process(roots[i].getUnwrapped());
        }
        System.out.println("Done.");
    }
    
    public void check(String path) {
        if (path.contains(needle)) {
            System.out.println(path);
        }
        if (new File(path).canRead()) {
            try {
                List<String> lines = new TextFile(path).getLines();
                String line;
                for(int i = 0; i < lines.size();i++) {
                    line = lines.get(i);
                    if (line.toLowerCase().contains(needle)) {
                        System.out.println(++item + ": " + path + " (" + (i+1) + ") : " + line);
                    }
                }
            } catch (Exception e) {
                if (e instanceof FileNotFoundException) {
                    ExceptionHandler.handleIO(SN + ".check",e.getMessage(),e,true);
                } else {
                    ExceptionHandler.handle(SN + ".check",e.getMessage(),e,false);
                }
                
            }
            
        }
    }
    
    public boolean include(String filePath) {
        String xt;
        boolean including;
        File aFile = new File(filePath);
        including = false;
        xt = aFile.getExtension();
        switch (xt) {
            case "c":
            case "cpp":
            case "html":
            case "java":
            case "php":
            case "pl":
            case "properties":
            case "py":
            case "sh":
            case "sql":
            case "txt":
                including = true;
                break;
            default:
                including = false;
                break;
        }
        if (debug) System.out.println(filePath + " : Incl.: " + including);
        return including;
    }

    public static void main(String[] args) {
        String needle = "TString";
        if (args.length == 1) {
            needle = args[0];
        } 
        //if (debug) System.out.println("ProjectPath: " + pp.getProjectPath());
        //new FindInFiles(pp.getProjectPath(),needle); 
        new FindInComputer(needle); 
    } 
 
    public void process(String path) {
        Pair pair = new Pair(new File(path));
        List<File> dirs = pair.getDirs();
        List<File> files = pair.getFiles();
        for(int i = 0; i < files.size();i++) {
            String unwrapped = files.get(i).getUnwrapped();
            if (files.get(i).getUnwrapped().contains(needle)) {
                System.out.println(++item + ": " + files.get(i).getAbsolutePath() + " (" + (i+1) + ")");
            }
            if (include(unwrapped)) check(unwrapped);
        }
        for(int i = 0; i < dirs.size();i++) {
            if (dirs.get(i).getUnwrapped().contains(needle)) {
                System.out.println(++item + ": " + dirs.get(i).getAbsolutePath() + " (" + (i+1) + ")");
            }
            process(dirs.get(i).getAbsolutePath());
        }
    }   
}
