package ca.tecreations.net;

import ca.tecreations.StringTool;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;

/**
 *
 * @author tim 
 */ 
public class SharedCode {
    public static boolean debug = false;
    
    public static void doLogAction(String msg) {
        doLogAction(null,msg);
    } 
     
    public static void doLogAction(TextFile log, String msg) {
        if (log != null) log.add(msg);
        System.out.println(msg);
    }
    
    public static String getDestinationFilename(String src, String args) {
        if (debug) System.out.println("SharedCode.getDestinationFilename: Args: '" + args + "'");
        String dst = null;
        int index = src.length();
        if (!args.startsWith("\"")) {
            index -= 2; // src isn't double quoted in args, so remove the quotes length that are added
        }
        if (src.length() < args.length()) {
            String remainder = args.substring(index + 1).trim();
            if (debug) System.out.println("SharedCode.getDestinationFilename: Remainder: '" + remainder + "'");
        
            if (remainder.startsWith("\"")) { // get a quoted parameter
                String quoted = getFirstQuoted(remainder);
                if (debug) System.out.println("SharedCode.getDestinationFilename: Quoted: '" + quoted + "'");
                return getFirstQuoted(remainder); 
            } else {
                // doesn't start with ", so, next block is all printable
                if (remainder.contains(" ")) { // still more than 1 parameters, first is unquoted
                    dst = remainder.substring(0,remainder.indexOf(" ")); 
                } else {
                    // no more args, just a single block without spaces, unquoted
                    dst = remainder;
                }
                dst = StringTool.getDoubleQuoted(dst);
            }
        }
        return dst;
    }
        
    public static String getFirstBackticked(String s) {
        String result = "`";
        for(int i = 1; i < s.length();i++) {
            //System.out.println(i + ": " + s.charAt(i));
            if (s.charAt(i) == '`') {
                result += '`'; // found it, append and return
                return result; 
            } else {
                result += s.charAt(i);
            }
        } 
        throw new IllegalArgumentException("SharedCode.getFirstBackticked: getFirstBackticked: UNMATCHED ('`'): '" + s + "' : '");
    }
    
    public static String getFirstQuoted(String s) {
        String result = "\"";
        for(int i = 1; i < s.length();i++) {
            //System.out.println(i + ": " + s.charAt(i));
            if (s.charAt(i) == '\"') {
                result += '\"'; // found it, append and return
                return result; 
            } else {
                result += s.charAt(i);
            }
        }
        throw new IllegalArgumentException("SharedCode: getFirstQuoted: UNMATCHED ('\"'): '" + s + "' : '");
    }
    
    public static String getNextChunk(String s,int length) {
        s = s.trim();
        char first = s.charAt(0);
        int secondIndex = s.indexOf(first,1);
        if (secondIndex == -1) {
            return s;
        } else {
            return s.substring(0,secondIndex + 1);
        }
    }
    
    public static String getSourceFilename(String args) {
        // note that for ca.tecreations.File, we output WITH a quote, unless unwrapped() is specified
        // and for a command, I wrap in backticks
        args = args.trim(); // get the block for args, no whiteapace on ends allowed
        String path = "";
        if (args.startsWith(TecData.DOUBLE_QUOTE)) { // is the first character a quote \" ????
            path = getFirstQuoted(args);
        } else if (args.startsWith(TecData.BACKTICK)) {
            path = getFirstBackticked(args);
        } else {
            // doesn't start with a quote, so the first argument is a contiguous block of printable characters
            if (args.contains(" ")) { // contains a space, so probably a destination too
                path = args.substring(0,args.indexOf(" ")); // not quoted, just return the first element
                                            // it will be up to the second argument, if called, to trim()
            } else {
                path = args; // only one argument
            } 
        }
        path = StringTool.getDoubleQuoted(path);
        return path;
    }

    public static boolean isPrompt(char[] array) {
        return ((array.length == 6)
                && (array[0] == 'p' | array[0] == 'P')
                && (array[1] == 'r' | array[1] == 'R')
                && (array[2] == 'o' | array[2] == 'O')
                && (array[3] == 'm' | array[3] == 'M')
                && (array[4] == 'p' | array[4] == 'P')
                && (array[5] == 't' | array[5] == 'T'));
    }

    public static void main(String[] args) {
        String args1 = "F:\\projects\\TIMS\\app\\TIMS.java";
        System.out.println("Next: " + getNextChunk(args1,11));
    }
    
    public String skipWhitespace(String s) {
        int index = 0;
        for(int i = 0;i < s.length();i++) {
            if (s.charAt(i) == ' ' | 
                s.charAt(i) == '\t' | 
                s.charAt(i) == '\n' | 
                s.charAt(i) == '\r'
               )
            {
                index++;
            } else {
                    // something not whitespace....
                break;
            }
        }
        return s.substring(index);
    }
    
}
