package ca.tecreations.net;

import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath; 
import ca.tecreations.Properties;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;

import java.net.InetAddress;
import java.net.UnknownHostException;

import java.util.List;

/** 
 * 
 * @author tim 
 */
public class NameService {
    public static boolean isStandalone = false;
    public static String propsPath = ProjectPath.getNetConfigPath() + "NameService.properties";
    public static Properties properties = new Properties(new File(propsPath));
    public static NameService INSTANCE = new NameService();

    
    public NameService() {
        if (properties.wasCreated()) {
            TextFile tf = new TextFile(propsPath);
            tf.add("#en: Format:->  '{Label}: {IP Address (ipV4)}'");
            tf.add("#----------------");
            System.out.println("TecVersion: " + TecData.TEC_VERSION);
            System.out.println("PrjDir    : " + ProjectPath.INSTANCE.getProjectDir());
            if (isStandalone && ProjectPath.INSTANCE.getProjectDir().equals(TecData.TEC_VERSION)) {
                tf.add("tecreations.ca: " + INSTANCE.getIPAddress("tecreations.ca"));
                tf.add("localhost: " + getLocalhostIPAddress());
                tf.add("Living Room: 192.168.1.103");
                tf.add("Basement Office: 192.168.1.3");
            }
            tf.add("");
            Platform.message(null,"You must configure the NameService data for your networks: " + propsPath);
            NameServiceConfigurer configurer = new NameServiceConfigurer();
            configurer.setVisible(true);
        }
    }
    
    public void deleteByKey(String name) {
        properties.deleteByKey(name);
    }
    
    public String getByName(String name) {
        if (!properties.getKeys().contains(name)) {
            properties.set(name,TecData.UNSET);
        }
        return properties.get(name);
    }
    
    public String getByIp(String ip) {
        return getByIPAddress(ip);
    }
    
    public String getByIP(String ip) {
        return getByIPAddress(ip);
    }
    
    public String getByIPAddress(String ip) {
        String retVal = "";
        String name = "";
        List<String> names = properties.getKeys();
        String testIp;
        for(int i = 0; i < names.size();i++) {
            testIp = properties.get(names.get(i));
            if (testIp.equals(ip)) {
                retVal = names.get(i);
                break;
            }
        }
        return retVal;
    }
    
    public String getIPAddress(String name) {
        String ip = TecData.UNSET_S;
        try {
            ip = InetAddress.getByName(name).getHostAddress();
        } catch (UnknownHostException uhe) {
        }
        return ip;
    }

    public static List<String> getLines() {
        TextFile tf = new TextFile(propsPath);
        return tf.getLines();
    }
    
    public static List<String> getListed() {
        return properties.getKeys();
    }
    
    public static String getLocalhostIPAddress() {
        String ip = TecData.UNSET_S;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException uhe) {
        }
        return ip;
    }
    
    public Properties getProperties() { return properties; }
    
    public String getPropertiesTag(String label) {
        return getByName(label);
    }
    
    public String getTag(String label) {
        if (!Internet.isIP(label)) {
            if (label.contains(".")) return label;
            else if (label.toLowerCase().equals("localhost")) {
                return "localhost";
            } else {
                String ip = getByName(label);
                if (ip.equals(Internet.getLanIP())) {
                    return "localhost";
                } else {
                    return ip;
                }
            }
        } else {
            return label;
        }
    }
    
    public static void main(String[] args) {
        isStandalone = true;
        new NameService();
        System.out.println("localhost: " + INSTANCE.getByName("localhost"));
        System.out.println("tecreations.ca: " + INSTANCE.getByName("tecreations.ca"));
        System.out.println("Living Room: " + INSTANCE.getByName("Living Room"));
        System.out.println("Basement Office: " + INSTANCE.getByName("Basement Office"));
                
    }
 
    protected void reset() {
        properties.reset();
    }
    
    public void retrieveUnset() {
        List<String> keys = properties.getKeys();
        String name;
        String ip;
        for(int i = 0; i < keys.size();i++) {
            name = keys.get(i);
            if (properties.get(name).equals(TecData.UNSET)) {
                ip = getIPAddress(name);
                if (!ip.equals(TecData.UNSET)) {
                    properties.set(name,ip);
                }
                              
            }
        }
    }
    
    public void set(String name) {
        if (!properties.hasKey(name)) {
            properties.set(name,TecData.UNSET);
        }
        String ip = getIPAddress(name);
        if (!ip.equals("")) {
            properties.set(name,ip);
        }
    }
            
    public void set(String name, String ip) {
        properties.set(name,ip); // auto-writes
    }
    
}
