package ca.tecreations.misc;

import java.awt.event.*;
/**
 *
 * @author Timothy
 */
public class KeyProcessor {
    KeyEvent e;
    int extendedKeyCode;
    int extendedKeyCodeForChar;
    char keyChar;
    int keyCode;
    int keyLocation;
    int keyModifiersEx;
    String keyText;
    boolean isActionKey; 
    
    public KeyProcessor(KeyEvent _e) {
        e = _e;
        extendedKeyCode = e.getExtendedKeyCode();
        extendedKeyCodeForChar =  e.getExtendedKeyCodeForChar(e.getKeyChar());
        keyChar = e.getKeyChar();
        keyCode = e.getKeyCode();
        keyLocation = e.getKeyLocation();
        keyText = e.getKeyText(e.getKeyCode());
        isActionKey = e.isActionKey();
        //printKeyEventData();
        //System.out.println(e.getKeyCode() == KeyEvent.VK_C);
        //if (trapCTRLc()) System.out.println("CTRL-C");
    }
    
    public boolean ctrlDown() {
        return (e.getModifiersEx() & e.CTRL_DOWN_MASK) == e.CTRL_DOWN_MASK;
    }
        
    public boolean isCTRL_C() {
        return keyCode == KeyEvent.VK_C && ctrlDown();
    }
    
    public boolean isCTRL_X() {
        return keyCode == KeyEvent.VK_X && ctrlDown();
    }
    
    public char getChar() { return keyChar; }
    
    public boolean isTab() { 
        return (keyCode == 9);
    }
    
    public boolean isEnter() {
        return keyText.equals("Enter");
    }
    
    public boolean isShift() {
        return (e.getModifiersEx() & e.SHIFT_DOWN_MASK) == e.SHIFT_DOWN_MASK;
    }
    
    public boolean isCtrl() {
        return (e.getModifiersEx() & e.CTRL_DOWN_MASK) == e.CTRL_DOWN_MASK;
    }
    
    public boolean isAlt() {
        return (e.getModifiersEx() & e.ALT_DOWN_MASK) == e.ALT_DOWN_MASK;
    }
    
    public boolean isCtrlShift() {
        return isCtrl() && isShift();
    }
    
    public boolean isCtrlAltShift() {
        return isCtrl() && isShift() && isAlt();
    }

    public boolean isAltShift() {
        return isAlt() && isShift();
    }
    
    public boolean isCtrlAlt() {
        return isCtrl() && isAlt();
    }
    
    public boolean isUp() {
        return (e.getKeyCode() == KeyEvent.VK_UP);
    }
    
    public boolean isDown() {
        return (e.getKeyCode() == KeyEvent.VK_DOWN);
    }

    public boolean isRight() {
        return (e.getKeyCode() == KeyEvent.VK_RIGHT);
    }
    
    public boolean isLeft() {
        return (e.getKeyCode() == KeyEvent.VK_LEFT);
    }
    
    public boolean isDelete() { 
        return keyText.equals("Delete");
    }
    
    public boolean isInsert() {
        return keyText.equals("Insert");
    }
    
    public boolean isHome() {
        return keyText.equals("Home");
    }
    
    public boolean isEnd() { 
        return keyText.equals("End");
    }
    
    public boolean isPageUp() { 
        return keyText.equals("Page Up");
    }
    
    public boolean isPageDown() {
        return keyText.equals("Page Down");
    }
    
//String	paramString()
//Returns a parameter string identifying this event.
//void	setKeyChar(char keyChar)
//Set the keyChar value to indicate a logical character.
//void	setKeyCode(int keyCode)
//Set the keyCode value to indicate a physical key.

//void	setModifiers(int modifiers)
//Deprecated. 
//as of JDK1.1.4

    public void printKeyEventData() {
        System.out.println("Key Event");
        System.out.println("=================================================");
        System.out.println(e.toString());
        System.out.println("=================================================");
        System.out.println("Key Code: " + keyCode);
        System.out.println("Key Char: '" + keyChar + "'");
        System.out.println("Extended Key Code: " + extendedKeyCode);
        System.out.println("Extended Key Code For Char: " + extendedKeyCodeForChar);
        System.out.println("Key Location: " + keyLocation);
        System.out.println("Modifiers Ex: " + e.getModifiersEx());
        System.out.println("Key Text: " + keyText);
        System.out.println("Is Action Key: " + isActionKey);
        System.out.println("IsAlt: " + isAlt());
        System.out.println("isCtrl: " + isCtrl());
        System.out.println("isShift: "  + isShift());
    }
    
    
}
        