package ca.tecreations.lang.java;

import ca.tecreations.File;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author tim
 */
public class FQCNSorter {
    List<FQCN> list;
    List<FQCN> sorted;

    public FQCNSorter(List<FQCN> list) {
        this.list = list;
        process();
    } 
    
    public List<FQCN> getSorted() { return sorted; }
    
    public static void main(String[] args) {
        List<FQCN> list = new ArrayList<>();
        list.add(new FQCN("test.tom.HelloWorld"));
        list.add(new FQCN("ca.timtest.Sort.timtest.test.Test"));
        list.add(new FQCN("ca.tecreations.misc.Time"));
        list.add(new FQCN("org.spring.Test"));
        list.add(new FQCN("ca.tecreations.Sort.test.Tim"));
        list.add(new FQCN("ca.tecreations.Test"));
        list.add(new FQCN("org.json.Test"));
        list.add(new FQCN("ca.tecreations.Sort"));
        list.add(new FQCN("ca.timtest.Sort"));
        list.add(new FQCN("ca.tecreations.apps.launcher.Launcher"));
        list.add(new FQCN("test.Test"));
        list.add(new FQCN("Compile"));
        list.add(new FQCN("ca.tecreations.lang.java.jars.GetMainClasses"));
        list.add(new FQCN("Build"));
        list.add(new FQCN("test.tim.HelloWorld"));
        list.add(new FQCN("sample.model.training.LLM"));
        list.add(new FQCN("sample.model.entities.Tim"));
        list.add(new FQCN("ca.tecreations.apps.deploy.Remote"));
        list.add(new FQCN("ca.tecreations.lang.java.jars.GetClassNames"));
        list.add(new FQCN("test.HelloWorld"));
        list.add(new FQCN("sample.controller.Test"));
        list.add(new FQCN("ca.tecreations.apps.deploy.Deploy"));
        FQCNSorter sorter = new FQCNSorter(list);
    }
    
    public void print(List<FQCN> list) {
        for(int i = 0; i < list.size();i++) {
            System.out.println(list.get(i).getFQCN());
        }
    }
    
    public void printGroups(List<List<FQCN>> groups) {
        for(int i = 0; i < groups.size();i++) {
            List<FQCN> group = groups.get(i);
            for(int j = 0; j < group.size();j++) {
                System.out.println(group.get(j).getFQCN());
            }
            System.out.println("==============================================");
        }
    }
    
    public void process() {
        // sort and group by 'root'
        list = sortByRoot(list);
        List<List<FQCN>> groups = regroupByRoot(list);
        List<List<FQCN>> sortedGroups = new ArrayList<>();
        for(int i = 0; i < groups.size();i++) {
            sortedGroups.add(sortByDomain(groups.get(i)));
        }
        
        // sort and group by 'domain'
        List<List<FQCN>> groupedByDomain;
        List<List<FQCN>> regroupedByDomain = new ArrayList<>();
        for(int i = 0; i < sortedGroups.size();i++) {
            groupedByDomain = regroupByDomain(sortedGroups.get(i));
            for(int j = 0; j < groupedByDomain.size();j++) {
                regroupedByDomain.add(groupedByDomain.get(j));
            }
        }
        
        // sort group by 'sub'
        List<List<FQCN>> sortedBySubs = new ArrayList<>();
        List<FQCN> group;
        for(int i = 0; i < regroupedByDomain.size();i++) {
            group = sortBySub(regroupedByDomain.get(i));
            sortedBySubs.add(group);
        }
        
        //printGroups(sortedBySubs);
        
        // regroup by 'sub'
        List<List<FQCN>> groupedBySub;
        List<List<FQCN>> regroupedBySub = new ArrayList<>();
        for(int i = 0; i < sortedBySubs.size();i++) {
            groupedBySub = regroupBySub(sortedBySubs.get(i));
            for(int j = 0; j < groupedBySub.size();j++) {
                regroupedBySub.add(groupedBySub.get(j));
            }
        }
        
        // sort group by 'name'
        List<List<FQCN>> sortedByName = new ArrayList<>();
        for(int i = 0; i < regroupedBySub.size();i++) {
            group = sortByName(regroupedBySub.get(i));
            sortedByName.add(group);
        }
        
        List<FQCN> compacted = new ArrayList<>();
        for(int i = 0; i < sortedByName.size();i++) {
            group = sortedByName.get(i);
            for(int j = 0; j < group.size();j++) {
                compacted.add(group.get(j));
            }
        }
        sorted = compacted;
    }
    
    public List<List<FQCN>> regroupByDomain(List<FQCN> list) {
        List<String> domains = new ArrayList<>();
        FQCN fqcn;
        String domain;
        for(int i = 0; i < list.size();i++) {
            fqcn = list.get(i);
            domain = fqcn.getDomain();
            boolean found = false;
            for(int j = 0; j < domains.size();j++) {
                if (domains.get(j).equals(domain)) {
                    found = true;
                    break;
                }
            }
            if (!found) domains.add(domain);
        }
        List<List<FQCN>> regrouped = new ArrayList<>();
        for(int i = 0; i < domains.size();i++) {
            domain = domains.get(i);
            regrouped.add(new ArrayList<>());
            for(int j = 0; j < list.size();j++) {
                if (list.get(j).getDomain().equals(domain)) {
                    regrouped.get(i).add(list.get(j));
                }
            }
        }
        return regrouped;
    }
    
    public List<List<FQCN>> regroupByRoot(List<FQCN> list) {
        List<String> roots = new ArrayList<>();
        String root;
        for(int i = 0; i < list.size();i++) {
            root = list.get(i).getRoot();
            boolean found = false;
            for(int j = 0; j < roots.size();j++) {
                if (roots.get(j).equals(root)) found = true;
            }
            if (!found) roots.add(root);
        }
        List<List<FQCN>> groups = new ArrayList<>();
        FQCN fqcn;
        for(int i = 0; i < roots.size();i++) {
            root = roots.get(i);
            groups.add(new ArrayList<>());
            for(int j = 0; j < list.size();j++) {
                fqcn = list.get(j);
                if (fqcn.getRoot().equals(root)) {
                    groups.get(i).add(fqcn);
                }
            }
            
        }
        return groups;
    }
    
    public List<List<FQCN>> regroupBySub(List<FQCN> list) {
        List<String> subs = new ArrayList<>();
        FQCN fqcn;
        String sub;
        for(int i = 0; i < list.size();i++) {
            fqcn = list.get(i);
            sub = fqcn.getSub();
            boolean found = false;
            for(int j = 0; j < subs.size();j++) {
                if (subs.get(j).equals(sub)) {
                    found = true;
                    break;
                }
            }
            if (!found) subs.add(sub);
        }
        List<List<FQCN>> regrouped = new ArrayList<>();
        for(int i = 0; i < subs.size();i++) {
            sub = subs.get(i);
            regrouped.add(new ArrayList<>());
            for(int j = 0; j < list.size();j++) {
                if (list.get(j).getSub().equals(sub)) {
                    regrouped.get(i).add(list.get(j));
                }
            }
        }
        return regrouped;
    }
    
    public List<FQCN> sortByDomain(List<FQCN> group) {
        int j;
        boolean flag = true;  // will determine when the sort is finished
        FQCN temp;
        
        while (flag) {
            flag = false;
            for( j = 0; j < group.size() - 1; j++) {
                //if ( x [ j ].compareToIgnoreCase( x [ j+1 ] ) > 0 )
                if (group.get(j).getDomain().compareToIgnoreCase(group.get(j+1).getDomain()) > 0) {
                    temp = group.get(j);
                    group.set(j,group.get(j+1));
                    group.set(j+1,temp);
                    flag = true;  
                } 
            }
        } 
        return group;
    }

    public List<FQCN> sortByName(List<FQCN> group) {
        int j;
        boolean flag = true;  // will determine when the sort is finished
        FQCN temp;
        
        while (flag) {
            flag = false;
            for( j = 0; j < group.size() - 1; j++) {
                //if ( x [ j ].compareToIgnoreCase( x [ j+1 ] ) > 0 )
                if (group.get(j).getName().compareToIgnoreCase(group.get(j+1).getName()) > 0) {
                    temp = group.get(j);
                    group.set(j,group.get(j+1));
                    group.set(j+1,temp);
                    flag = true;  
                } 
            }
        } 
        return group;
    }

    public List<FQCN> sortByRoot(List<FQCN> list) {
        int j;
        boolean flag = true;  // will determine when the sort is finished
        FQCN temp;
        
        while (flag) {
            flag = false;
            for( j = 0; j < list.size() - 1; j++) {
                //if ( x [ j ].compareToIgnoreCase( x [ j+1 ] ) > 0 )
                if (list.get(j).getRoot().compareToIgnoreCase(list.get(j+1).getRoot()) > 0) {
                    temp = list.get(j);
                    list.set(j,list.get(j+1));
                    list.set(j+1,temp);
                    flag = true;  
                } 
            }
        } 
        return list;
    }
    
    public List<FQCN> sortBySub(List<FQCN> list) {
        int j;
        boolean flag = true;  // will determine when the sort is finished
        FQCN temp;
        
        while (flag) {
            flag = false;
            for( j = 0; j < list.size() - 1; j++) {
                //if ( x [ j ].compareToIgnoreCase( x [ j+1 ] ) > 0 )
                if (list.get(j).getSub().compareToIgnoreCase(list.get(j+1).getSub()) > 0) {
                    temp = list.get(j);
                    list.set(j,list.get(j+1));
                    list.set(j+1,temp);
                    flag = true;  
                } 
            }
        } 
        return list;
    }
}
