package ca.tecreations.graphics;

import ca.tecreations.*;

import java.awt.Color;
import java.awt.image.*;
/**
 *
 * @author Tim
 */
public class ImageScanner {
    BufferedImage image;
    int x = 0;
    int y = 0;
    
    public ImageScanner(BufferedImage img) {
        this.image = img;
    }
    
    public Point collideE(Color c) {
        int cRGB = c.getRGB();
        while (ImageTool.extract(image,x,y - 1,1,1)[0] != cRGB) {
            x++;
        }
        return new Point(x,y);
    }
    
    public Point collideSE(Color c) {
        int cRGB = c.getRGB();
        while (ImageTool.extract(image,x,y,1,1)[0] != cRGB) {
            y++;
        }
        while (ImageTool.extract(image,x,y - 1, 1, 1)[0] != cRGB) {
            x++;
        }
        return new Point(x,y);
    }
    
    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
    }
    
}
