package ca.tecreations.db.mysql;

import ca.tecreations.Platform;
import ca.tecreations.TextFile;
import ca.tecreations.TypeToType;
import ca.tecreations.db.DB;
import ca.tecreations.components.GetPassword;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
 
import javax.sql.DataSource;
import javax.swing.JFrame;

public class MySQL extends DB {
    private static final String className = "MySQL";
    int port = 3306;
    String url;
    boolean isDataSource = false;
    DataSource dataSource = null;
    Statement stmt = null;
    ResultSet rs = null;
    List<String> errors = new ArrayList<>();
    
    public MySQL(DataSource dataSource, String url, String user, char[] pass) {
        isDataSource = true;
        this.dataSource = dataSource;
        this.url = url;
        this.host = getHostNameFromURL(url);
        this.user = user;
        this.pass = pass;
        conn = attemptOpen();
    }

    public MySQL(DataSource dataSource) {
        isDataSource = true;
        this.dataSource = dataSource;
        conn = attemptOpen();
    }

    public MySQL(String url, String user, char[] pass) {
        this.url = url;
        this.host = getHostNameFromURL(url);
        this.user = user;
        this.pass = pass;
        conn = attemptOpen();
    }
    
    public MySQL(String host,int port, String user, char[] pass) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.pass = pass;
        url = "jdbc:mysql://" + host + ":" + port + "/?user=" + user + "&password=" + TypeToType.toString(pass);
        conn = attemptOpen();
    }
    
    public MySQL(String host,int port, String dbName,  String user, char[] pass) {
        this.host = host;
        this.port = port;
        this.dbName = dbName;
        this.user = user;
        this.pass = pass;
        url = "jdbc:mysql://" + host + ":" + port + "/" + dbName + "?user=" + user + "&password=" + TypeToType.toString(pass);
        System.out.println("Connecting to: " + url);
        conn = attemptOpen();
    }
    
    public MySQL(String host,int port, String dbName,  String user) {
        this.host = host;
        this.port = port;
        this.dbName = dbName;
        this.user = user;
        GetPassword dialog = new GetPassword(new JFrame(),"Enter Password For: " + host + ":" + port + "/" + dbName + "/user=" + user);
        dialog.setVisible(true);
        while (dialog.isVisible()) {
            Platform.sleep(500);
        }
        if (dialog.getPassword() != null) {
            this.pass = dialog.getPassword();
        }
        url = "jdbc:mysql://" + host + ":" + port + "/" + dbName + "?user=" + user + "&password=" + pass;
        conn = attemptOpen();
    }
    
    public MySQL(String host,String dbName,  String user) {
        this.host = host;
        this.dbName = dbName;
        this.user = user;
        GetPassword dialog = new GetPassword(new JFrame(),"Enter Password For: " + host + ":" + port + "/" + dbName + "/user=" + user);
        dialog.setVisible(true);
        while (dialog.isVisible()) {
            Platform.sleep(500);
        }
        if (dialog.getPassword() != null) {
            this.pass = dialog.getPassword();
        }
        // this demonstrates that, you must not have unauthorized people on your machine... this password gets exposed
        url = "jdbc:mysql://" + host + ":" + port + "/" + dbName;
        
        url += "?user=" + user;
        url += "&password=" + TypeToType.charArrayToString(pass);
        conn = attemptOpen();
    }
    
    public void addError(String s) {
        errors.add(s);
    }
    
    public Connection attemptOpen() {
        return new GetMySQLConnection(this).getConnection();
    }
    
    public void clearErrors() {
        errors = new ArrayList<>();
    }
    
    public void closeConnection() {
        sqlException = null;
        try {
            conn.close();
            conn = null;
        } catch (SQLException sqle) {
                if (debug) System.err.println("MySQL.closeConnection: " + sqle);
            sqlException = sqle;
        }
    }
    
    public void closeStatement() {
        sqlException = null;
        try {
            stmt.close();
            stmt = null;
        } catch (SQLException sqle) {
                if (debug) System.err.println("MySQL.closeStatement: " + sqle);
            sqlException = sqle;
        }
    }
    
    public void closeResultSet() {
        sqlException = null;
        if (rs != null) {
            try {
                rs.close();
            } catch (SQLException sqle) {
                if (debug) System.err.println("MySQL.closeResultSet: " + sqle);
                sqlException = sqle;
            }
        }
    }
    
    public int countRows(String sql,boolean debug) {
        List<String> values = getValues(sql,debug);
        if (values == null || values.size() == 0) return 0;
        if (values.size() == 1) return Integer.parseInt(values.get(0));
        return 0;
    }

    /**
     * executes countRows(false)
     * @param sql
     * @return 
     */
    public int countRows(String sql) {
        return countRows(sql,false);
    }
    
    public void flushPrivileges() {
        issue("FLUSH PRIVILEGES",false);
    }
    
    public void flushPrivileges(boolean debug) {
        issue("FLUSH PRIVILEGES",debug);
    }
    
    public String get(String sql, String value) {
        return get(sql,value,debug);
    }
    
    public String get(String sql,String value, boolean debug) {
        sqlException = null;
        String result = "";
        rs = query(sql, debug);
        try {
            rs.next();
            result = rs.getString(value);
        } catch (SQLException sqle) {
            if (debug) System.out.println(className + ".get: " + sqle);
            sqlException = sqle;
        } finally {
            closeResultSet();
        }
        return result;
    }
    
    public String getClassName() { return className; }
    
    public int getColumnCount(ResultSet rs) {
        sqlException = null;
        try {
            ResultSetMetaData metadata = rs.getMetaData();
            int count = metadata.getColumnCount();
            return count;
        } catch (SQLException sqle) {
            if (debug) System.out.println(className + ".getColumnCount: " + sqle);
            sqlException = sqle;
            return -1;
        }
    }
    
    /**
     * 
     * @param rs The result set to operate on.
     * @param name The name of the column - case sensitive
     * @return The index of the column (zero-based) or -1 if not found.
     */
    public int getColumnIndex(String sql,String name) {
        rs = getResultSet(sql,debug);
        List<String> names = getColumnNames(rs);
        int index = -1;
        for(int i = 0; i < names.size();i++) {
            if (names.get(i).equals(name)) {
                index = i;
                break;
            }
        }
        closeResultSet();
        return index;
    }
    
    public String getColummName(String sql,int index) {
        rs = getResultSet(sql,debug);
        List<String> names = getColumnNames(rs);
        closeResultSet();
        return names.get(index);
    }

    
    
    public List<String> getColumnNames(ResultSet rs) {
        sqlException = null;
        List<String> names = new ArrayList<>();
        if (rs != null) {
            try {
                ResultSetMetaData md = (ResultSetMetaData)rs.getMetaData();
                int count = md.getColumnCount();
                for(int i = 0;i < count;i++) {
                    names.add(md.getColumnLabel(i + 1));
                }
            } catch (SQLException sqle) {
                 if (debug) System.out.println("MySQL.getColumnNames: " + sqle);
            }
        } else System.err.println("ResultSet is null in MySQL.getColumnNames");
        return names;
    }
    
    public Connection getConnection() { return conn; }
    
    public List<String> getErrors() { return errors; }
    
    public SQLException getException() { return sqlException; }
    
    public String getHostNameFromURL(String url) {
        int index = url.indexOf("://");
        System.out.println("Index (//): " + index);
        String hostPart = url.substring(index + 3,url.indexOf("/",index + 3));
        if (hostPart.contains(":")) {
            return hostPart.substring(0,hostPart.indexOf(":"));
        } else {
            return hostPart;
        }
    }
      
    public String getProvider() { return "MySQL"; }
    
    public ResultSet getResultSet(String sql, boolean debug) {
        return query(sql,debug);
    }
    
    public List<List<String>> getRows(String sql,boolean withHeader) {
        sqlException = null;
        rs = getResultSet(sql,debug);
        List<List<String>> rows = new ArrayList<>();
        List<String> columnNames = getColumnNames(rs);
        if (withHeader) {
            if (columnNames.size() > 0) {
                rows.add(columnNames);
            }
        }
        if (rs != null) {
            List<String> row;
            try {
                rs.beforeFirst();
                while (rs.next()) {
                    row = new ArrayList<>();
                    for(int i = 0; i < columnNames.size();i++) {
                        row.add(rs.getString(columnNames.get(i)));
                    }
                    rows.add(row);
                }
            } catch (SQLException sqle) {
                if (debug) System.out.println(className + ".getRows(" + rs + "," + withHeader + "): " + sqle);
                sqlException = sqle;
            }
            closeResultSet();
        }
        return rows;
    }
     
    public List<List<String>> getRows(String sql,boolean withHeader, boolean debug) {
        sqlException = null;
        if (!sql.endsWith(";")) sql += ";";
        rs = getResultSet(sql,debug);
        List<List<String>> rows = new ArrayList<>();
        List<String> columnNames = getColumnNames(rs);
        if (columnNames.size() > 0) {
            if (withHeader) rows.add(columnNames);
        }
        List<String> row;
        if (rs != null) {
            try {
                rs.beforeFirst();
                while (rs.next()) {
                    row = new ArrayList<>();
                    for(int i = 0; i < columnNames.size();i++) {
                        row.add(rs.getString(columnNames.get(i)));
                    }
                    rows.add(row);
                }
            } catch (SQLException sqle) {
                if (debug) System.out.println(className + ".getRows(" + sql + "," + withHeader + "): " + sqle);
                sqlException = sqle;
            }
        } else System.err.println("ResultSet == null in MySQL.getRows('" + sql + "',withHeader: " + withHeader + ")");
        closeResultSet();
        return rows;
    }
    
    public String getValue(String sql) {
        return getValue(sql,debug);
    }
    
    public String getValue(String sql,boolean debug) {
        List<List<String>> rows = getRows(sql,false,debug);
        if (rows == null) return null;
        List<String> row;
        if (rows.size() > 0) {
            row = rows.get(0);
            return row.get(0);
        } 
        return null;
    }
    
    public List<String> getValues(String sql) {
        return getValues(sql,debug);
    }
    
    public List<String> getValues(String sql,boolean debug) {
        List<List<String>> rows = getRows(sql,false,debug);
        List<String> vals = new ArrayList<>();
        for(int i = 0; i < rows.size();i++) {
            vals.add(rows.get(i).get(0));
        }
        return vals;
    } 
    
    public boolean isConnected() {
        sqlException = null;
        if (conn == null) return false;
        try {
            return !conn.isClosed();
        } catch (SQLException sqle) {
            if (debug) System.out.println(className + ".isConnected: " + sqle);
            sqlException = sqle;
        }
        return false;
    }
    
    public void issue(String sql) {
        issue(sql,debug);
    }
    
    public void issue(String sql,boolean debug) { 
        if (conn == null) conn = attemptOpen();
        if (conn == null) System.err.println("MySQL.issue: conn is null");
        sqlException = null;
        affected = -999;  
        if (!sql.endsWith(";")) sql += ";";
        if (debug) System.out.println("SQL: " + sql);
        try {
            stmt = conn.createStatement();
        } catch (SQLException sqle) {
            System.err.println(className + ".issue: (1) SQLException: " + sqle);
        }
        if (sql.trim().toLowerCase().startsWith("update ")) {
            try {
                // if the sql fails, affected will be -999
                affected = stmt.executeUpdate(sql);
            } catch (SQLException sqle) {
                if (debug) System.out.println(className + ".issue: (2) SQLException: " + sqle);
                sqlException = sqle;
            }
        } else {
            try {
                stmt.execute(sql);
                affected = stmt.getUpdateCount();
            } catch (SQLException sqle) {
                if (debug) System.out.println(className + ".issue: (3) SQLException: " + sqle);
                sqlException = sqle;
            }
        }
        if (affected == -999) {
            System.err.println("SQL: '" + sql + "' : Failed");
        } else {
            if (debug) {
                System.out.println("OK: Affected:" + affected);
            } 
        }
        closeStatement();
    }
    
    public void makeTableFromSQL(String filename) {
        makeTableFromSQL(filename,debug);
    }
    
    public void makeTableFromSQL(String filename,boolean debug) {
        List<String> sqlLines = Platform.getFileLines(filename);
        String sql = "";
        for(int i = 0; i < sqlLines.size();i++) {
            sql += sqlLines.get(i);
        }
        issue(sql,debug);
        if (sqlException != null) {
            System.out.println("Exception: " + sqlException);
        }
    }

    // considers # or // a single line comment
    public void parseAndExecute(String path,boolean debug) {
        if (debug) System.out.println("MySQL.parseAndExecute: " + path + " debug: " + debug);
        TextFile file = new TextFile(path);
        List<String> lines = file.getLines();
        String batch = "";
        String line;
        for(int i = 0; i < lines.size();i++) {
            line = lines.get(i).trim();
            if (!line.startsWith("#") && !line.startsWith("//")) {
                if (lines.get(i).trim().endsWith(";")) { 
                    batch += lines.get(i);
                    issue(batch,debug); 
                    batch = "";
                } else if (!lines.get(i).trim().equals("")) {
                    batch += lines.get(i);
                }
            }
        }
    } 
    
    public ResultSet query(String sql) {
        return query(sql,debug);
    }


    /**
     * MySQL.query returns the results of the query, so you must close them yourselves, as we do in this class.
     * @param sql -- string the sql statement
     * @param debug -- boolean -- enable trace and customized error output printing -- you could, any type, I try to debug, so there's that
     * @return 
     */
    public ResultSet query(String sql,boolean debug) {
        if (conn == null) conn = attemptOpen();
        sqlException = null;
        if (!sql.endsWith(";")) sql += ";";
        if (debug) System.out.println("SQL: " + sql);
        try {
            stmt = conn.createStatement (ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY);
        } catch (SQLException sqle) {
            System.out.println(className + ".query(1): " + sql + " Exception: " + sqle);
            sqlException = sqle;
        }
        if (stmt != null) {
            try {
                rs = stmt.executeQuery(sql);
            } catch (SQLException sqle) {
                System.out.println(className + ".query(2): " + sql + " Exception: " + sqle);
                sqlException = sqle;
            }
            //try {
            //    stmt.close();
            //} catch (SQLException sqle) {
            //    if (debug) System.out.println("MySQL.query(" + sql + "): Couldn't close Statement.");
            //    else System.out.println("MySQL.query(): Couldn't close Statiement");
            //}
        } else {
            if (debug) System.out.println("MySQL.query(" + sql + "): Unable to createStatement.");
            else System.out.println("MySQL.query(): Unable to createStatement.");
        }
        return rs;        
    }

    public void setConnection(Connection c) {
        this.conn = c;
    }
    
    public void setSQLException(SQLException sqle) {
        this.sqlException = sqle; 
    }
    
    /**
     * This should be considered deprecated. It worked for a time to load the JDBC connector jar but is no longer
     * necessary given the way the tecreations packages work together now. It may be useful for someone, but one 
     * should use the tecreations packages to fully experience what can be done. MySQL and MySQL_Ops, db.* should
     * probably be included in the current tecreations package, along with its' dependency jars so everyone has
     * access to at least one external database.
     * @param path
     * @throws Exception 
     */
/** DELETE    
    public static void loadJar(String path) throws Exception {
        File f = new File(path);
        URL u = f.toURI().toURL();
        URLClassLoader urlClassLoader = (URLClassLoader) ClassLoader.getSystemClassLoader();
        Class<?> urlClass = URLClassLoader.class;
        Method method = urlClass.getDeclaredMethod("addURL", new Class[]{URL.class});
        method.setAccessible(true);
        method.invoke(urlClassLoader, new Object[]{u});
    }
*/
}
