 package ca.tecreations.components;

import ca.tecreations.*;

import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class Status extends JPanel implements ActionListener, MouseListener,
        MouseMotionListener, MouseWheelListener {
    StatusCommand command = null;
    StatusColor color = null;
    StatusMouse mouse = null;
    StatusScale scale = null;
    StatusText text = null;
    
    List<ActionListener> als = new ArrayList<>();
    List<MouseListener> mls = new ArrayList<>();
    List<MouseMotionListener> mmls = new ArrayList<>();
    List<MouseWheelListener> mwls = new ArrayList<>();
    
    public Status(boolean command, boolean color, boolean mouse, boolean scale, boolean text) {
        setLayout(new BoxLayout(this, BoxLayout.LINE_AXIS));
        add(Box.createHorizontalGlue());
        if (command) {
            this.command = new StatusCommand(this);
            add(this.command);
        }
        if (color) {
            if (command) {
            this.color = new StatusColor(this);
                    add(Box.createRigidArea(new Dimension(10,0)));
            }
            this.color = new StatusColor(this);
            add(this.color);
        }
        if (mouse) {
            if (command || color) {
                add(Box.createRigidArea(new Dimension(10,0)));
            }
            this.mouse = new StatusMouse(this);
            add(this.mouse);
        }
        if (scale) {
            if (command || color || mouse) {
                add(Box.createRigidArea(new Dimension(10,0)));
            }
            this.scale = new StatusScale(this);
            add(this.scale);
        }
        if (text) {
            if (command || color || mouse || scale) {
                add(Box.createRigidArea(new Dimension(10,0)));
            }
            this.text = new StatusText(this);
            add(this.text);
        }
    }

    public void actionPerformed(ActionEvent e) { for(int i = 0; i < als.size();i++) als.get(i).actionPerformed(e); }

    
    public void addActionListener(ActionListener al) { if (!als.contains(al)) als.add(al); }
    public void addMouseListener(MouseListener ml) { if (!mls.contains(ml)) mls.add(ml); }
    public void addMouseMotionListener(MouseMotionListener mml) { if (!mmls.contains(mml)) mmls.add(mml); }
    public void addMouseWheelListener(MouseWheelListener mwl) { if (!mwls.contains(mwl)) mwls.add(mwl); }
    
    public void mouseClicked(MouseEvent e) { for(int i = 0; i < mls.size();i++) mls.get(i).mouseClicked(e); }
    public void mouseDragged(MouseEvent e) { for(int i = 0; i < mmls.size();i++) mmls.get(i).mouseDragged(e); }
    public void mouseEntered(MouseEvent e) { for(int i = 0; i < mls.size();i++) mls.get(i).mouseEntered(e); }
    public void mouseExited(MouseEvent e) { for(int i = 0; i < mls.size();i++) mls.get(i).mouseExited(e); }
    public void mouseMoved(MouseEvent e) { for(int i = 0; i < mmls.size();i++) mmls.get(i).mouseMoved(e); }
    public void mousePressed(MouseEvent e) { for(int i = 0; i < mls.size();i++) mls.get(i).mousePressed(e); }
    public void mouseReleased(MouseEvent e) { for(int i = 0; i < mls.size();i++) mls.get(i).mouseReleased(e); }
    public void mouseWheelMoved(MouseWheelEvent e) { for(int i = 0; i < mwls.size();i++) mwls.get(i).mouseWheelMoved(e); }
    
    public StatusColor getColor() { return color; }
    
    public StatusCommand getCommand() { return command; }
    
    public String getCommandText() { return command.getCommandText(); }
    
    public StatusMouse getMouse() { return mouse; }
    
    public StatusScale getScale() { return scale; }
    
    public StatusText getText() { return text; }
    
    public void setColor(Color c) {
        color.setColor(c);
    }
    
    public void updateMouse(int x, int y) {
        mouse.updateMouse(x,y);
    }
}
