package ca.tecreations.components;
import ca.tecreations.Point;
import ca.tecreations.ProjectPath;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.*;
import javax.swing.JPanel;
import javax.swing.Timer;
/**
 *
 * @author Tim
 */
public class Handle extends Movable implements ActionListener, MouseListener, MouseMotionListener {
    protected Container parent;
    public static int size = 7;
    public static int half = (size + 1)/ 2;
    public boolean running = false;
    Thread thread = null;
    Color handleColor = Color.black;
    public boolean flashBackground = false;
    public boolean flashing = false;
    public boolean flash = false;
    public Color flashColor = null;
    Timer timer;
    
    public Handle() {
        this(NONE);
        timer = new Timer(500,this);
    }
    
    public Handle(int constrain) {
        super(constrain);
        setBackground(Color.white);
        setSize(size,size);
        addMouseListener(this);
        addMouseMotionListener(this);
        timer = new Timer(500,this);
    }
    
    public void actionPerformed(ActionEvent e) {
        flash = !flash;
        repaint();
    }
    
    public void centerOn(int x, int y) {
        setLocation(x - half,y - half);
    }
    
    public int getBottom() {
        return getLocation().y + size;
    }
    
    public int getCX() {
        return getLocation().x + half;
    }
    
    public Point getCXY() {
        return new Point(getCX(),getCY());
    }
    
    public int getCY() {
        return getLocation().y + half;
    }
    
    public Point getDXY() {
        return new Point(getDX(),getDY());
    }
    
    public int getLeft() {
        return getLocation().x;
    }
    
    public int getRight() {
        return getLocation().x + size;
    }
    
    public int getTop() {
        return getLocation().y;
    }

    public static int getXOffset(Handle h1, Handle h2) {
        if (h1.getCX() < h2.getCX()) return h2.getCX() - h1.getCX();
        return h1.getCX() - h2.getCX();
    }
    
    public static int getYOffset(Handle h1, Handle h2) {
        if (h1.getCY() < h2.getCY()) return h2.getCY() - h1.getCY();
        return h1.getCY() - h2.getCY();
    }

    public void moveBy(int x, int y) {
        java.awt.Point loc = getLocation();
        setLocation(loc.x + x, loc.y + y);
    }
    
    public void paintComponent(Graphics g) {
        if (parent == null) parent = getParent();
        super.paintComponent(g);
        if (flashing) {
            if (flashColor == null) g.setColor(new Color((int)(Math.random() * 256),(int)(Math.random() * 256), (int)(Math.random() * 256)));
            if (flash) {
                g.setColor(Color.white);
            } else {
                g.setColor(Color.black);
            }
        }
        else g.setColor(getBackground());
        g.fillRect(1,1,getSize().width - 2, getSize().height - 2);
        g.setColor(Color.black);
        g.drawRect(0,0,getSize().width - 1, getSize().height - 1);
    }
    
    public void setFlashBackground(boolean state) {
        flashBackground = state;
    }
    
    public String toString() {
        java.awt.Point p = getLocation();
        return "Handle [" + p.x + "," + p.y + "]";
    }
    
    public void mouseEntered(MouseEvent e) {
        if (flashBackground) flashing = true;
        timer.start();
    }
    
    public void mouseExited(MouseEvent e) {
        flashing = false;
        timer.stop();
        repaint();
    }
    
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (getDebug()) {
            System.out.println("Handle.mousePressed");
            System.out.println("Parent: " + parent);
        }
    }
    
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
    }
    
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        if (getDX() == 0 && getDY() == 0) return;
        //System.out.println("Handle.mouseDragged: " + getDX() + "," + getDY() + " Parent: " + parent);
    }
    
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
    }
    
    public static void main(String[] args) {
        TFrame app = new TFrame(ProjectPath.getTecPropsPath() + "Handle.properties","HandleTestFrame");
        JPanel holder = new JPanel();
        holder.setLayout(null);
        app.add(holder,BorderLayout.CENTER);
        Handle normal = new Handle(Movable.NONE);
        Handle random = new Handle(Movable.VERTICAL);
        Handle redHandle = new Handle(Movable.HORIZONTAL);
        random.setFlashBackground(true);
        random.setLocation(Handle.size * 10, Handle.size * 10);
        redHandle.setBackground(Color.red);
        redHandle.setLocation(Handle.size * 20, Handle.size * 20);
        holder.add(normal);
        holder.add(random);
        holder.add(redHandle);
        app.setVisible(true);
    }
    
    public void setFlashColor(Color c) { flashColor = c; }
    
}
