package ca.tecreations.apps.filetool;

import ca.tecreations.ExceptionHandler;
import ca.tecreations.Platform;
import ca.tecreations.Point;
import ca.tecreations.net.Client;
import ca.tecreations.net.NoTLSConnectionException;

/**
 *
 * @author Tim
 */
public class ScreenRefresher extends Thread {
    public static final String SN = ScreenRefresher.class.getSimpleName();
    RemoteControl remote;
    Client client;
    boolean running;
    Point mouseLoc;
    
    public ScreenRefresher(RemoteControl rc, Client client) {
        this.remote = rc;
        this.client = client;
    }
    
    public boolean isRunning() { return running; }
    
    public void restart() {
        if (!running) start();
    }
    
    @Override
    public void run() {
        while (running) {
            Platform.sleep(2000); // refresh any changes every two seconds
            try {
                client = new Client(client);
            } catch (NoTLSConnectionException ntlsce) {
                ExceptionHandler.handle(SN + ".run: No TLS Connection",ntlsce);
            }
            remote.setImage(client.getServerDesktop());
        }
    }
    
    @Override
    public void start() {
        running = true;
        super.start();
    }
    
    public void stopRunning() { running = false; }
}
