package ca.tecreations.apps._gui;

import ca.tecreations.apps._gui.renderer.*;
/**
 * @author tim
 */
public class FileEntriesTableModelDOS extends FileEntriesTableModel {
    protected String[] columnNames;
    protected Class[] columnClass;

    public FileEntriesTableModelDOS(EntriesPanel panel,FileEntriesTable table) {
        super(panel,table);
        columnNames = new String[] {
            "Name", "Size", "JVM Perms.", "Modified", "DOS Attributes"
        };
        columnClass = new Class[] {
            FileTypeRenderer.class, FileSizeRenderer.class, AppAccessRenderer.class, FileDateRenderer.class, FileAttributesRenderer.class
        };
    } 
  
    @Override
    public String getColumnName(int column)
    {
        return columnNames[column];
    }
 
    @Override
    public Class<?> getColumnClass(int columnIndex)
    {
        return columnClass[columnIndex];
    }
 
    @Override
    public int getColumnCount()
    {
        return columnNames.length;
    }
}
